package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterRoleBindingListBuilder extends io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluentImpl<io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListBuilder> {

    io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterRoleBindingListBuilder() {
        this(true);
    }

    public ClusterRoleBindingListBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterRoleBindingList(), validationEnabled);
    }

    public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterRoleBindingList(), validationEnabled);
    }

    public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList instance) {
        this(fluent, instance, true);
    }

    public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList instance) {
        this(instance,true);
    }

    public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList build() {
        ClusterRoleBindingList buildable = new ClusterRoleBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterRoleBindingListBuilder that = (ClusterRoleBindingListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
