/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelector;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.AllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceHandle;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceHandleBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceHandleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AllocationResultFluent<A extends AllocationResultFluent<A>>
extends BaseFluent<A> {
    private NodeSelector availableOnNodes;
    private ArrayList<ResourceHandleBuilder> resourceHandles = new ArrayList();
    private Boolean shareable;
    private Map<String, Object> additionalProperties;

    public AllocationResultFluent() {
    }

    public AllocationResultFluent(AllocationResult instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AllocationResult instance) {
        AllocationResult allocationResult = instance = instance != null ? instance : new AllocationResult();
        if (instance != null) {
            this.withAvailableOnNodes(instance.getAvailableOnNodes());
            this.withResourceHandles(instance.getResourceHandles());
            this.withShareable(instance.getShareable());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NodeSelector getAvailableOnNodes() {
        return this.availableOnNodes;
    }

    public A withAvailableOnNodes(NodeSelector availableOnNodes) {
        this.availableOnNodes = availableOnNodes;
        return (A)((Object)this);
    }

    public boolean hasAvailableOnNodes() {
        return this.availableOnNodes != null;
    }

    public A addToResourceHandles(int index, ResourceHandle item) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList();
        }
        ResourceHandleBuilder builder = new ResourceHandleBuilder(item);
        if (index < 0 || index >= this.resourceHandles.size()) {
            this._visitables.get((Object)"resourceHandles").add(builder);
            this.resourceHandles.add(builder);
        } else {
            this._visitables.get((Object)"resourceHandles").add(index, builder);
            this.resourceHandles.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResourceHandles(int index, ResourceHandle item) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList();
        }
        ResourceHandleBuilder builder = new ResourceHandleBuilder(item);
        if (index < 0 || index >= this.resourceHandles.size()) {
            this._visitables.get((Object)"resourceHandles").add(builder);
            this.resourceHandles.add(builder);
        } else {
            this._visitables.get((Object)"resourceHandles").set(index, builder);
            this.resourceHandles.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResourceHandles(ResourceHandle ... items) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList();
        }
        for (ResourceHandle item : items) {
            ResourceHandleBuilder builder = new ResourceHandleBuilder(item);
            this._visitables.get((Object)"resourceHandles").add(builder);
            this.resourceHandles.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResourceHandles(Collection<ResourceHandle> items) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList();
        }
        for (ResourceHandle item : items) {
            ResourceHandleBuilder builder = new ResourceHandleBuilder(item);
            this._visitables.get((Object)"resourceHandles").add(builder);
            this.resourceHandles.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResourceHandles(ResourceHandle ... items) {
        if (this.resourceHandles == null) {
            return (A)((Object)this);
        }
        for (ResourceHandle item : items) {
            ResourceHandleBuilder builder = new ResourceHandleBuilder(item);
            this._visitables.get((Object)"resourceHandles").remove((Object)builder);
            this.resourceHandles.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResourceHandles(Collection<ResourceHandle> items) {
        if (this.resourceHandles == null) {
            return (A)((Object)this);
        }
        for (ResourceHandle item : items) {
            ResourceHandleBuilder builder = new ResourceHandleBuilder(item);
            this._visitables.get((Object)"resourceHandles").remove((Object)builder);
            this.resourceHandles.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResourceHandles(Predicate<ResourceHandleBuilder> predicate) {
        if (this.resourceHandles == null) {
            return (A)((Object)this);
        }
        Iterator<ResourceHandleBuilder> each = this.resourceHandles.iterator();
        List visitables = this._visitables.get((Object)"resourceHandles");
        while (each.hasNext()) {
            ResourceHandleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ResourceHandle> buildResourceHandles() {
        return this.resourceHandles != null ? AllocationResultFluent.build(this.resourceHandles) : null;
    }

    public ResourceHandle buildResourceHandle(int index) {
        return this.resourceHandles.get(index).build();
    }

    public ResourceHandle buildFirstResourceHandle() {
        return this.resourceHandles.get(0).build();
    }

    public ResourceHandle buildLastResourceHandle() {
        return this.resourceHandles.get(this.resourceHandles.size() - 1).build();
    }

    public ResourceHandle buildMatchingResourceHandle(Predicate<ResourceHandleBuilder> predicate) {
        for (ResourceHandleBuilder item : this.resourceHandles) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceHandle(Predicate<ResourceHandleBuilder> predicate) {
        for (ResourceHandleBuilder item : this.resourceHandles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceHandles(List<ResourceHandle> resourceHandles) {
        if (this.resourceHandles != null) {
            this._visitables.get((Object)"resourceHandles").clear();
        }
        if (resourceHandles != null) {
            this.resourceHandles = new ArrayList();
            for (ResourceHandle item : resourceHandles) {
                this.addToResourceHandles(item);
            }
        } else {
            this.resourceHandles = null;
        }
        return (A)((Object)this);
    }

    public A withResourceHandles(ResourceHandle ... resourceHandles) {
        if (this.resourceHandles != null) {
            this.resourceHandles.clear();
            this._visitables.remove((Object)"resourceHandles");
        }
        if (resourceHandles != null) {
            for (ResourceHandle item : resourceHandles) {
                this.addToResourceHandles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResourceHandles() {
        return this.resourceHandles != null && !this.resourceHandles.isEmpty();
    }

    public A addNewResourceHandle(String data, String driverName) {
        return this.addToResourceHandles(new ResourceHandle(data, driverName));
    }

    public ResourceHandlesNested<A> addNewResourceHandle() {
        return new ResourceHandlesNested(-1, null);
    }

    public ResourceHandlesNested<A> addNewResourceHandleLike(ResourceHandle item) {
        return new ResourceHandlesNested(-1, item);
    }

    public ResourceHandlesNested<A> setNewResourceHandleLike(int index, ResourceHandle item) {
        return new ResourceHandlesNested(index, item);
    }

    public ResourceHandlesNested<A> editResourceHandle(int index) {
        if (this.resourceHandles.size() <= index) {
            throw new RuntimeException("Can't edit resourceHandles. Index exceeds size.");
        }
        return this.setNewResourceHandleLike(index, this.buildResourceHandle(index));
    }

    public ResourceHandlesNested<A> editFirstResourceHandle() {
        if (this.resourceHandles.size() == 0) {
            throw new RuntimeException("Can't edit first resourceHandles. The list is empty.");
        }
        return this.setNewResourceHandleLike(0, this.buildResourceHandle(0));
    }

    public ResourceHandlesNested<A> editLastResourceHandle() {
        int index = this.resourceHandles.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceHandles. The list is empty.");
        }
        return this.setNewResourceHandleLike(index, this.buildResourceHandle(index));
    }

    public ResourceHandlesNested<A> editMatchingResourceHandle(Predicate<ResourceHandleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceHandles.size(); ++i) {
            if (!predicate.test(this.resourceHandles.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceHandles. No match found.");
        }
        return this.setNewResourceHandleLike(index, this.buildResourceHandle(index));
    }

    public Boolean getShareable() {
        return this.shareable;
    }

    public A withShareable(Boolean shareable) {
        this.shareable = shareable;
        return (A)((Object)this);
    }

    public boolean hasShareable() {
        return this.shareable != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AllocationResultFluent that = (AllocationResultFluent)((Object)o);
        if (!Objects.equals(this.availableOnNodes, that.availableOnNodes)) {
            return false;
        }
        if (!Objects.equals(this.resourceHandles, that.resourceHandles)) {
            return false;
        }
        if (!Objects.equals(this.shareable, that.shareable)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.availableOnNodes, this.resourceHandles, this.shareable, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableOnNodes != null) {
            sb.append("availableOnNodes:");
            sb.append(this.availableOnNodes + ",");
        }
        if (this.resourceHandles != null && !this.resourceHandles.isEmpty()) {
            sb.append("resourceHandles:");
            sb.append(this.resourceHandles + ",");
        }
        if (this.shareable != null) {
            sb.append("shareable:");
            sb.append(this.shareable + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withShareable() {
        return this.withShareable(true);
    }

    public class ResourceHandlesNested<N>
    extends ResourceHandleFluent<ResourceHandlesNested<N>>
    implements Nested<N> {
        ResourceHandleBuilder builder;
        int index;

        ResourceHandlesNested(int index, ResourceHandle item) {
            this.index = index;
            this.builder = new ResourceHandleBuilder(this, item);
        }

        public N and() {
            return (N)AllocationResultFluent.this.setToResourceHandles(this.index, this.builder.build());
        }

        public N endResourceHandle() {
            return this.and();
        }
    }
}

