package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DriverAllocationResultFluent<A extends DriverAllocationResultFluent<A>> extends BaseFluent<A>{
  public DriverAllocationResultFluent() {
  }
  
  public DriverAllocationResultFluent(DriverAllocationResult instance) {
    this.copyInstance(instance);
  }
  private NamedResourcesAllocationResultBuilder namedResources;
  private Map<String,Object> vendorRequestParameters;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DriverAllocationResult instance) {
    instance = (instance != null ? instance : new DriverAllocationResult());
    if (instance != null) {
          this.withNamedResources(instance.getNamedResources());
          this.withVendorRequestParameters(instance.getVendorRequestParameters());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NamedResourcesAllocationResult buildNamedResources() {
    return this.namedResources != null ? this.namedResources.build() : null;
  }
  
  public A withNamedResources(NamedResourcesAllocationResult namedResources) {
    this._visitables.remove("namedResources");
    if (namedResources != null) {
        this.namedResources = new NamedResourcesAllocationResultBuilder(namedResources);
        this._visitables.get("namedResources").add(this.namedResources);
    } else {
        this.namedResources = null;
        this._visitables.get("namedResources").remove(this.namedResources);
    }
    return (A) this;
  }
  
  public boolean hasNamedResources() {
    return this.namedResources != null;
  }
  
  public A withNewNamedResources(String name) {
    return (A)withNamedResources(new NamedResourcesAllocationResult(name));
  }
  
  public NamedResourcesNested<A> withNewNamedResources() {
    return new NamedResourcesNested(null);
  }
  
  public NamedResourcesNested<A> withNewNamedResourcesLike(NamedResourcesAllocationResult item) {
    return new NamedResourcesNested(item);
  }
  
  public NamedResourcesNested<A> editNamedResources() {
    return withNewNamedResourcesLike(java.util.Optional.ofNullable(buildNamedResources()).orElse(null));
  }
  
  public NamedResourcesNested<A> editOrNewNamedResources() {
    return withNewNamedResourcesLike(java.util.Optional.ofNullable(buildNamedResources()).orElse(new NamedResourcesAllocationResultBuilder().build()));
  }
  
  public NamedResourcesNested<A> editOrNewNamedResourcesLike(NamedResourcesAllocationResult item) {
    return withNewNamedResourcesLike(java.util.Optional.ofNullable(buildNamedResources()).orElse(item));
  }
  
  public A addToVendorRequestParameters(String key,Object value) {
    if(this.vendorRequestParameters == null && key != null && value != null) { this.vendorRequestParameters = new LinkedHashMap(); }
    if(key != null && value != null) {this.vendorRequestParameters.put(key, value);} return (A)this;
  }
  
  public A addToVendorRequestParameters(Map<String,Object> map) {
    if(this.vendorRequestParameters == null && map != null) { this.vendorRequestParameters = new LinkedHashMap(); }
    if(map != null) { this.vendorRequestParameters.putAll(map);} return (A)this;
  }
  
  public A removeFromVendorRequestParameters(String key) {
    if(this.vendorRequestParameters == null) { return (A) this; }
    if(key != null && this.vendorRequestParameters != null) {this.vendorRequestParameters.remove(key);} return (A)this;
  }
  
  public A removeFromVendorRequestParameters(Map<String,Object> map) {
    if(this.vendorRequestParameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.vendorRequestParameters != null){this.vendorRequestParameters.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getVendorRequestParameters() {
    return this.vendorRequestParameters;
  }
  
  public <K,V>A withVendorRequestParameters(Map<String,Object> vendorRequestParameters) {
    if (vendorRequestParameters == null) {
      this.vendorRequestParameters = null;
    } else {
      this.vendorRequestParameters = new LinkedHashMap(vendorRequestParameters);
    }
    return (A) this;
  }
  
  public boolean hasVendorRequestParameters() {
    return this.vendorRequestParameters != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DriverAllocationResultFluent that = (DriverAllocationResultFluent) o;
    if (!java.util.Objects.equals(namedResources, that.namedResources)) return false;
    if (!java.util.Objects.equals(vendorRequestParameters, that.vendorRequestParameters)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(namedResources,  vendorRequestParameters,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (namedResources != null) { sb.append("namedResources:"); sb.append(namedResources + ","); }
    if (vendorRequestParameters != null && !vendorRequestParameters.isEmpty()) { sb.append("vendorRequestParameters:"); sb.append(vendorRequestParameters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NamedResourcesNested<N> extends NamedResourcesAllocationResultFluent<NamedResourcesNested<N>> implements Nested<N>{
    NamedResourcesNested(NamedResourcesAllocationResult item) {
      this.builder = new NamedResourcesAllocationResultBuilder(this, item);
    }
    NamedResourcesAllocationResultBuilder builder;
    
    public N and() {
      return (N) DriverAllocationResultFluent.this.withNamedResources(builder.build());
    }
    
    public N endNamedResources() {
      return and();
    }
    
  
  }

}