package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodSchedulingStatusFluentImpl<A extends PodSchedulingStatusFluent<A>> extends BaseFluent<A> implements PodSchedulingStatusFluent<A>{
  public PodSchedulingStatusFluentImpl() {
  }
  public PodSchedulingStatusFluentImpl(PodSchedulingStatus instance) {
    this.withResourceClaims(instance.getResourceClaims()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ResourceClaimSchedulingStatusBuilder> resourceClaims = new ArrayList<ResourceClaimSchedulingStatusBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToResourceClaims(Integer index,ResourceClaimSchedulingStatus item) {
    if (this.resourceClaims == null) {this.resourceClaims = new ArrayList<ResourceClaimSchedulingStatusBuilder>();}
    ResourceClaimSchedulingStatusBuilder builder = new ResourceClaimSchedulingStatusBuilder(item);_visitables.get("resourceClaims").add(index >= 0 ? index : _visitables.get("resourceClaims").size(), builder);this.resourceClaims.add(index >= 0 ? index : resourceClaims.size(), builder); return (A)this;
  }
  public A setToResourceClaims(Integer index,ResourceClaimSchedulingStatus item) {
    if (this.resourceClaims == null) {this.resourceClaims = new ArrayList<ResourceClaimSchedulingStatusBuilder>();}
    ResourceClaimSchedulingStatusBuilder builder = new ResourceClaimSchedulingStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("resourceClaims").size()) { _visitables.get("resourceClaims").add(builder); } else { _visitables.get("resourceClaims").set(index, builder);}
    if (index < 0 || index >= resourceClaims.size()) { resourceClaims.add(builder); } else { resourceClaims.set(index, builder);}
     return (A)this;
  }
  public A addToResourceClaims(io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimSchedulingStatus... items) {
    if (this.resourceClaims == null) {this.resourceClaims = new ArrayList<ResourceClaimSchedulingStatusBuilder>();}
    for (ResourceClaimSchedulingStatus item : items) {ResourceClaimSchedulingStatusBuilder builder = new ResourceClaimSchedulingStatusBuilder(item);_visitables.get("resourceClaims").add(builder);this.resourceClaims.add(builder);} return (A)this;
  }
  public A addAllToResourceClaims(Collection<ResourceClaimSchedulingStatus> items) {
    if (this.resourceClaims == null) {this.resourceClaims = new ArrayList<ResourceClaimSchedulingStatusBuilder>();}
    for (ResourceClaimSchedulingStatus item : items) {ResourceClaimSchedulingStatusBuilder builder = new ResourceClaimSchedulingStatusBuilder(item);_visitables.get("resourceClaims").add(builder);this.resourceClaims.add(builder);} return (A)this;
  }
  public A removeFromResourceClaims(io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimSchedulingStatus... items) {
    for (ResourceClaimSchedulingStatus item : items) {ResourceClaimSchedulingStatusBuilder builder = new ResourceClaimSchedulingStatusBuilder(item);_visitables.get("resourceClaims").remove(builder);if (this.resourceClaims != null) {this.resourceClaims.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceClaims(Collection<ResourceClaimSchedulingStatus> items) {
    for (ResourceClaimSchedulingStatus item : items) {ResourceClaimSchedulingStatusBuilder builder = new ResourceClaimSchedulingStatusBuilder(item);_visitables.get("resourceClaims").remove(builder);if (this.resourceClaims != null) {this.resourceClaims.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceClaims(Predicate<ResourceClaimSchedulingStatusBuilder> predicate) {
    if (resourceClaims == null) return (A) this;
    final Iterator<ResourceClaimSchedulingStatusBuilder> each = resourceClaims.iterator();
    final List visitables = _visitables.get("resourceClaims");
    while (each.hasNext()) {
      ResourceClaimSchedulingStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResourceClaims instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceClaimSchedulingStatus> getResourceClaims() {
    return resourceClaims != null ? build(resourceClaims) : null;
  }
  public List<ResourceClaimSchedulingStatus> buildResourceClaims() {
    return resourceClaims != null ? build(resourceClaims) : null;
  }
  public ResourceClaimSchedulingStatus buildResourceClaim(Integer index) {
    return this.resourceClaims.get(index).build();
  }
  public ResourceClaimSchedulingStatus buildFirstResourceClaim() {
    return this.resourceClaims.get(0).build();
  }
  public ResourceClaimSchedulingStatus buildLastResourceClaim() {
    return this.resourceClaims.get(resourceClaims.size() - 1).build();
  }
  public ResourceClaimSchedulingStatus buildMatchingResourceClaim(Predicate<ResourceClaimSchedulingStatusBuilder> predicate) {
    for (ResourceClaimSchedulingStatusBuilder item: resourceClaims) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResourceClaim(Predicate<ResourceClaimSchedulingStatusBuilder> predicate) {
    for (ResourceClaimSchedulingStatusBuilder item: resourceClaims) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceClaims(List<ResourceClaimSchedulingStatus> resourceClaims) {
    if (this.resourceClaims != null) { _visitables.get("resourceClaims").removeAll(this.resourceClaims);}
    if (resourceClaims != null) {this.resourceClaims = new ArrayList(); for (ResourceClaimSchedulingStatus item : resourceClaims){this.addToResourceClaims(item);}} else { this.resourceClaims = null;} return (A) this;
  }
  public A withResourceClaims(io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimSchedulingStatus... resourceClaims) {
    if (this.resourceClaims != null) {this.resourceClaims.clear();}
    if (resourceClaims != null) {for (ResourceClaimSchedulingStatus item :resourceClaims){ this.addToResourceClaims(item);}} return (A) this;
  }
  public Boolean hasResourceClaims() {
    return resourceClaims != null && !resourceClaims.isEmpty();
  }
  public PodSchedulingStatusFluent.ResourceClaimsNested<A> addNewResourceClaim() {
    return new PodSchedulingStatusFluentImpl.ResourceClaimsNestedImpl();
  }
  public PodSchedulingStatusFluent.ResourceClaimsNested<A> addNewResourceClaimLike(ResourceClaimSchedulingStatus item) {
    return new PodSchedulingStatusFluentImpl.ResourceClaimsNestedImpl(-1, item);
  }
  public PodSchedulingStatusFluent.ResourceClaimsNested<A> setNewResourceClaimLike(Integer index,ResourceClaimSchedulingStatus item) {
    return new PodSchedulingStatusFluentImpl.ResourceClaimsNestedImpl(index, item);
  }
  public PodSchedulingStatusFluent.ResourceClaimsNested<A> editResourceClaim(Integer index) {
    if (resourceClaims.size() <= index) throw new RuntimeException("Can't edit resourceClaims. Index exceeds size.");
    return setNewResourceClaimLike(index, buildResourceClaim(index));
  }
  public PodSchedulingStatusFluent.ResourceClaimsNested<A> editFirstResourceClaim() {
    if (resourceClaims.size() == 0) throw new RuntimeException("Can't edit first resourceClaims. The list is empty.");
    return setNewResourceClaimLike(0, buildResourceClaim(0));
  }
  public PodSchedulingStatusFluent.ResourceClaimsNested<A> editLastResourceClaim() {
    int index = resourceClaims.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceClaims. The list is empty.");
    return setNewResourceClaimLike(index, buildResourceClaim(index));
  }
  public PodSchedulingStatusFluent.ResourceClaimsNested<A> editMatchingResourceClaim(Predicate<ResourceClaimSchedulingStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceClaims.size();i++) { 
    if (predicate.test(resourceClaims.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceClaims. No match found.");
    return setNewResourceClaimLike(index, buildResourceClaim(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodSchedulingStatusFluentImpl that = (PodSchedulingStatusFluentImpl) o;
    if (resourceClaims != null ? !resourceClaims.equals(that.resourceClaims) :that.resourceClaims != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(resourceClaims,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resourceClaims != null && !resourceClaims.isEmpty()) { sb.append("resourceClaims:"); sb.append(resourceClaims + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ResourceClaimsNestedImpl<N> extends ResourceClaimSchedulingStatusFluentImpl<PodSchedulingStatusFluent.ResourceClaimsNested<N>> implements PodSchedulingStatusFluent.ResourceClaimsNested<N>,Nested<N>{
    ResourceClaimsNestedImpl(Integer index,ResourceClaimSchedulingStatus item) {
      this.index = index;
      this.builder = new ResourceClaimSchedulingStatusBuilder(this, item);
    }
    ResourceClaimsNestedImpl() {
      this.index = -1;
      this.builder = new ResourceClaimSchedulingStatusBuilder(this);
    }
    ResourceClaimSchedulingStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSchedulingStatusFluentImpl.this.setToResourceClaims(index,builder.build());
    }
    public N endResourceClaim() {
      return and();
    }
    
  }
  
}