package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceClaimStatusFluentImpl<A extends ResourceClaimStatusFluent<A>> extends BaseFluent<A> implements ResourceClaimStatusFluent<A>{
  public ResourceClaimStatusFluentImpl() {
  }
  public ResourceClaimStatusFluentImpl(ResourceClaimStatus instance) {
    this.withAllocation(instance.getAllocation()); 
    this.withDeallocationRequested(instance.getDeallocationRequested()); 
    this.withDriverName(instance.getDriverName()); 
    this.withReservedFor(instance.getReservedFor()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private AllocationResultBuilder allocation;
  private Boolean deallocationRequested;
  private String driverName;
  private ArrayList<ResourceClaimConsumerReferenceBuilder> reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAllocation instead.
   * @return The buildable object.
   */
  @Deprecated
  public AllocationResult getAllocation() {
    return this.allocation!=null ?this.allocation.build():null;
  }
  public AllocationResult buildAllocation() {
    return this.allocation!=null ?this.allocation.build():null;
  }
  public A withAllocation(AllocationResult allocation) {
    _visitables.get("allocation").remove(this.allocation);
    if (allocation!=null){ this.allocation= new AllocationResultBuilder(allocation); _visitables.get("allocation").add(this.allocation);} else { this.allocation = null; _visitables.get("allocation").remove(this.allocation); } return (A) this;
  }
  public Boolean hasAllocation() {
    return this.allocation != null;
  }
  public ResourceClaimStatusFluent.AllocationNested<A> withNewAllocation() {
    return new ResourceClaimStatusFluentImpl.AllocationNestedImpl();
  }
  public ResourceClaimStatusFluent.AllocationNested<A> withNewAllocationLike(AllocationResult item) {
    return new ResourceClaimStatusFluentImpl.AllocationNestedImpl(item);
  }
  public ResourceClaimStatusFluent.AllocationNested<A> editAllocation() {
    return withNewAllocationLike(getAllocation());
  }
  public ResourceClaimStatusFluent.AllocationNested<A> editOrNewAllocation() {
    return withNewAllocationLike(getAllocation() != null ? getAllocation(): new AllocationResultBuilder().build());
  }
  public ResourceClaimStatusFluent.AllocationNested<A> editOrNewAllocationLike(AllocationResult item) {
    return withNewAllocationLike(getAllocation() != null ? getAllocation(): item);
  }
  public Boolean getDeallocationRequested() {
    return this.deallocationRequested;
  }
  public A withDeallocationRequested(Boolean deallocationRequested) {
    this.deallocationRequested=deallocationRequested; return (A) this;
  }
  public Boolean hasDeallocationRequested() {
    return this.deallocationRequested != null;
  }
  public String getDriverName() {
    return this.driverName;
  }
  public A withDriverName(String driverName) {
    this.driverName=driverName; return (A) this;
  }
  public Boolean hasDriverName() {
    return this.driverName != null;
  }
  public A addToReservedFor(Integer index,ResourceClaimConsumerReference item) {
    if (this.reservedFor == null) {this.reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();}
    ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);_visitables.get("reservedFor").add(index >= 0 ? index : _visitables.get("reservedFor").size(), builder);this.reservedFor.add(index >= 0 ? index : reservedFor.size(), builder); return (A)this;
  }
  public A setToReservedFor(Integer index,ResourceClaimConsumerReference item) {
    if (this.reservedFor == null) {this.reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();}
    ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("reservedFor").size()) { _visitables.get("reservedFor").add(builder); } else { _visitables.get("reservedFor").set(index, builder);}
    if (index < 0 || index >= reservedFor.size()) { reservedFor.add(builder); } else { reservedFor.set(index, builder);}
     return (A)this;
  }
  public A addToReservedFor(io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimConsumerReference... items) {
    if (this.reservedFor == null) {this.reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();}
    for (ResourceClaimConsumerReference item : items) {ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);_visitables.get("reservedFor").add(builder);this.reservedFor.add(builder);} return (A)this;
  }
  public A addAllToReservedFor(Collection<ResourceClaimConsumerReference> items) {
    if (this.reservedFor == null) {this.reservedFor = new ArrayList<ResourceClaimConsumerReferenceBuilder>();}
    for (ResourceClaimConsumerReference item : items) {ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);_visitables.get("reservedFor").add(builder);this.reservedFor.add(builder);} return (A)this;
  }
  public A removeFromReservedFor(io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimConsumerReference... items) {
    for (ResourceClaimConsumerReference item : items) {ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);_visitables.get("reservedFor").remove(builder);if (this.reservedFor != null) {this.reservedFor.remove(builder);}} return (A)this;
  }
  public A removeAllFromReservedFor(Collection<ResourceClaimConsumerReference> items) {
    for (ResourceClaimConsumerReference item : items) {ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);_visitables.get("reservedFor").remove(builder);if (this.reservedFor != null) {this.reservedFor.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
    if (reservedFor == null) return (A) this;
    final Iterator<ResourceClaimConsumerReferenceBuilder> each = reservedFor.iterator();
    final List visitables = _visitables.get("reservedFor");
    while (each.hasNext()) {
      ResourceClaimConsumerReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildReservedFor instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceClaimConsumerReference> getReservedFor() {
    return reservedFor != null ? build(reservedFor) : null;
  }
  public List<ResourceClaimConsumerReference> buildReservedFor() {
    return reservedFor != null ? build(reservedFor) : null;
  }
  public ResourceClaimConsumerReference buildReservedFor(Integer index) {
    return this.reservedFor.get(index).build();
  }
  public ResourceClaimConsumerReference buildFirstReservedFor() {
    return this.reservedFor.get(0).build();
  }
  public ResourceClaimConsumerReference buildLastReservedFor() {
    return this.reservedFor.get(reservedFor.size() - 1).build();
  }
  public ResourceClaimConsumerReference buildMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
    for (ResourceClaimConsumerReferenceBuilder item: reservedFor) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
    for (ResourceClaimConsumerReferenceBuilder item: reservedFor) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReservedFor(List<ResourceClaimConsumerReference> reservedFor) {
    if (this.reservedFor != null) { _visitables.get("reservedFor").removeAll(this.reservedFor);}
    if (reservedFor != null) {this.reservedFor = new ArrayList(); for (ResourceClaimConsumerReference item : reservedFor){this.addToReservedFor(item);}} else { this.reservedFor = null;} return (A) this;
  }
  public A withReservedFor(io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimConsumerReference... reservedFor) {
    if (this.reservedFor != null) {this.reservedFor.clear();}
    if (reservedFor != null) {for (ResourceClaimConsumerReference item :reservedFor){ this.addToReservedFor(item);}} return (A) this;
  }
  public Boolean hasReservedFor() {
    return reservedFor != null && !reservedFor.isEmpty();
  }
  public A addNewReservedFor(String apiGroup,String name,String resource,String uid) {
    return (A)addToReservedFor(new ResourceClaimConsumerReference(apiGroup, name, resource, uid));
  }
  public ResourceClaimStatusFluent.ReservedForNested<A> addNewReservedFor() {
    return new ResourceClaimStatusFluentImpl.ReservedForNestedImpl();
  }
  public ResourceClaimStatusFluent.ReservedForNested<A> addNewReservedForLike(ResourceClaimConsumerReference item) {
    return new ResourceClaimStatusFluentImpl.ReservedForNestedImpl(-1, item);
  }
  public ResourceClaimStatusFluent.ReservedForNested<A> setNewReservedForLike(Integer index,ResourceClaimConsumerReference item) {
    return new ResourceClaimStatusFluentImpl.ReservedForNestedImpl(index, item);
  }
  public ResourceClaimStatusFluent.ReservedForNested<A> editReservedFor(Integer index) {
    if (reservedFor.size() <= index) throw new RuntimeException("Can't edit reservedFor. Index exceeds size.");
    return setNewReservedForLike(index, buildReservedFor(index));
  }
  public ResourceClaimStatusFluent.ReservedForNested<A> editFirstReservedFor() {
    if (reservedFor.size() == 0) throw new RuntimeException("Can't edit first reservedFor. The list is empty.");
    return setNewReservedForLike(0, buildReservedFor(0));
  }
  public ResourceClaimStatusFluent.ReservedForNested<A> editLastReservedFor() {
    int index = reservedFor.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last reservedFor. The list is empty.");
    return setNewReservedForLike(index, buildReservedFor(index));
  }
  public ResourceClaimStatusFluent.ReservedForNested<A> editMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<reservedFor.size();i++) { 
    if (predicate.test(reservedFor.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching reservedFor. No match found.");
    return setNewReservedForLike(index, buildReservedFor(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceClaimStatusFluentImpl that = (ResourceClaimStatusFluentImpl) o;
    if (allocation != null ? !allocation.equals(that.allocation) :that.allocation != null) return false;
    if (deallocationRequested != null ? !deallocationRequested.equals(that.deallocationRequested) :that.deallocationRequested != null) return false;
    if (driverName != null ? !driverName.equals(that.driverName) :that.driverName != null) return false;
    if (reservedFor != null ? !reservedFor.equals(that.reservedFor) :that.reservedFor != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allocation,  deallocationRequested,  driverName,  reservedFor,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocation != null) { sb.append("allocation:"); sb.append(allocation + ","); }
    if (deallocationRequested != null) { sb.append("deallocationRequested:"); sb.append(deallocationRequested + ","); }
    if (driverName != null) { sb.append("driverName:"); sb.append(driverName + ","); }
    if (reservedFor != null && !reservedFor.isEmpty()) { sb.append("reservedFor:"); sb.append(reservedFor + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withDeallocationRequested() {
    return withDeallocationRequested(true);
  }
  class AllocationNestedImpl<N> extends AllocationResultFluentImpl<ResourceClaimStatusFluent.AllocationNested<N>> implements ResourceClaimStatusFluent.AllocationNested<N>,Nested<N>{
    AllocationNestedImpl(AllocationResult item) {
      this.builder = new AllocationResultBuilder(this, item);
    }
    AllocationNestedImpl() {
      this.builder = new AllocationResultBuilder(this);
    }
    AllocationResultBuilder builder;
    public N and() {
      return (N) ResourceClaimStatusFluentImpl.this.withAllocation(builder.build());
    }
    public N endAllocation() {
      return and();
    }
    
  }
  class ReservedForNestedImpl<N> extends ResourceClaimConsumerReferenceFluentImpl<ResourceClaimStatusFluent.ReservedForNested<N>> implements ResourceClaimStatusFluent.ReservedForNested<N>,Nested<N>{
    ReservedForNestedImpl(Integer index,ResourceClaimConsumerReference item) {
      this.index = index;
      this.builder = new ResourceClaimConsumerReferenceBuilder(this, item);
    }
    ReservedForNestedImpl() {
      this.index = -1;
      this.builder = new ResourceClaimConsumerReferenceBuilder(this);
    }
    ResourceClaimConsumerReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) ResourceClaimStatusFluentImpl.this.setToReservedFor(index,builder.build());
    }
    public N endReservedFor() {
      return and();
    }
    
  }
  
}