package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceClaimSpecFluentImpl<A extends ResourceClaimSpecFluent<A>> extends BaseFluent<A> implements ResourceClaimSpecFluent<A>{
  public ResourceClaimSpecFluentImpl() {
  }
  public ResourceClaimSpecFluentImpl(ResourceClaimSpec instance) {
    this.withAllocationMode(instance.getAllocationMode()); 
    this.withParametersRef(instance.getParametersRef()); 
    this.withResourceClassName(instance.getResourceClassName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String allocationMode;
  private ResourceClaimParametersReferenceBuilder parametersRef;
  private String resourceClassName;
  private Map<String,Object> additionalProperties;
  public String getAllocationMode() {
    return this.allocationMode;
  }
  public A withAllocationMode(String allocationMode) {
    this.allocationMode=allocationMode; return (A) this;
  }
  public Boolean hasAllocationMode() {
    return this.allocationMode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildParametersRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceClaimParametersReference getParametersRef() {
    return this.parametersRef!=null ?this.parametersRef.build():null;
  }
  public ResourceClaimParametersReference buildParametersRef() {
    return this.parametersRef!=null ?this.parametersRef.build():null;
  }
  public A withParametersRef(ResourceClaimParametersReference parametersRef) {
    _visitables.get("parametersRef").remove(this.parametersRef);
    if (parametersRef!=null){ this.parametersRef= new ResourceClaimParametersReferenceBuilder(parametersRef); _visitables.get("parametersRef").add(this.parametersRef);} else { this.parametersRef = null; _visitables.get("parametersRef").remove(this.parametersRef); } return (A) this;
  }
  public Boolean hasParametersRef() {
    return this.parametersRef != null;
  }
  public A withNewParametersRef(String apiGroup,String kind,String name) {
    return (A)withParametersRef(new ResourceClaimParametersReference(apiGroup, kind, name));
  }
  public ResourceClaimSpecFluent.ParametersRefNested<A> withNewParametersRef() {
    return new ResourceClaimSpecFluentImpl.ParametersRefNestedImpl();
  }
  public ResourceClaimSpecFluent.ParametersRefNested<A> withNewParametersRefLike(ResourceClaimParametersReference item) {
    return new ResourceClaimSpecFluentImpl.ParametersRefNestedImpl(item);
  }
  public ResourceClaimSpecFluent.ParametersRefNested<A> editParametersRef() {
    return withNewParametersRefLike(getParametersRef());
  }
  public ResourceClaimSpecFluent.ParametersRefNested<A> editOrNewParametersRef() {
    return withNewParametersRefLike(getParametersRef() != null ? getParametersRef(): new ResourceClaimParametersReferenceBuilder().build());
  }
  public ResourceClaimSpecFluent.ParametersRefNested<A> editOrNewParametersRefLike(ResourceClaimParametersReference item) {
    return withNewParametersRefLike(getParametersRef() != null ? getParametersRef(): item);
  }
  public String getResourceClassName() {
    return this.resourceClassName;
  }
  public A withResourceClassName(String resourceClassName) {
    this.resourceClassName=resourceClassName; return (A) this;
  }
  public Boolean hasResourceClassName() {
    return this.resourceClassName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceClaimSpecFluentImpl that = (ResourceClaimSpecFluentImpl) o;
    if (allocationMode != null ? !allocationMode.equals(that.allocationMode) :that.allocationMode != null) return false;
    if (parametersRef != null ? !parametersRef.equals(that.parametersRef) :that.parametersRef != null) return false;
    if (resourceClassName != null ? !resourceClassName.equals(that.resourceClassName) :that.resourceClassName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allocationMode,  parametersRef,  resourceClassName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocationMode != null) { sb.append("allocationMode:"); sb.append(allocationMode + ","); }
    if (parametersRef != null) { sb.append("parametersRef:"); sb.append(parametersRef + ","); }
    if (resourceClassName != null) { sb.append("resourceClassName:"); sb.append(resourceClassName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ParametersRefNestedImpl<N> extends ResourceClaimParametersReferenceFluentImpl<ResourceClaimSpecFluent.ParametersRefNested<N>> implements ResourceClaimSpecFluent.ParametersRefNested<N>,Nested<N>{
    ParametersRefNestedImpl(ResourceClaimParametersReference item) {
      this.builder = new ResourceClaimParametersReferenceBuilder(this, item);
    }
    ParametersRefNestedImpl() {
      this.builder = new ResourceClaimParametersReferenceBuilder(this);
    }
    ResourceClaimParametersReferenceBuilder builder;
    public N and() {
      return (N) ResourceClaimSpecFluentImpl.this.withParametersRef(builder.build());
    }
    public N endParametersRef() {
      return and();
    }
    
  }
  
}