package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClassParametersReferenceBuilder extends ResourceClassParametersReferenceFluentImpl<ResourceClassParametersReferenceBuilder> implements VisitableBuilder<ResourceClassParametersReference,ResourceClassParametersReferenceBuilder>{
  public ResourceClassParametersReferenceBuilder() {
    this(false);
  }
  public ResourceClassParametersReferenceBuilder(Boolean validationEnabled) {
    this(new ResourceClassParametersReference(), validationEnabled);
  }
  public ResourceClassParametersReferenceBuilder(ResourceClassParametersReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClassParametersReferenceBuilder(ResourceClassParametersReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClassParametersReference(), validationEnabled);
  }
  public ResourceClassParametersReferenceBuilder(ResourceClassParametersReferenceFluent<?> fluent,ResourceClassParametersReference instance) {
    this(fluent, instance, false);
  }
  public ResourceClassParametersReferenceBuilder(ResourceClassParametersReferenceFluent<?> fluent,ResourceClassParametersReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroup(instance.getApiGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceClassParametersReferenceBuilder(ResourceClassParametersReference instance) {
    this(instance,false);
  }
  public ResourceClassParametersReferenceBuilder(ResourceClassParametersReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroup(instance.getApiGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ResourceClassParametersReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClassParametersReference build() {
    ResourceClassParametersReference buildable = new ResourceClassParametersReference(fluent.getApiGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}