/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimSchedulingStatus;
import io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClaimSchedulingStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceClaimSchedulingStatusFluentImpl<A extends ResourceClaimSchedulingStatusFluent<A>>
extends BaseFluent<A>
implements ResourceClaimSchedulingStatusFluent<A> {
    private String name;
    private List<String> unsuitableNodes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ResourceClaimSchedulingStatusFluentImpl() {
    }

    public ResourceClaimSchedulingStatusFluentImpl(ResourceClaimSchedulingStatus instance) {
        this.withName(instance.getName());
        this.withUnsuitableNodes(instance.getUnsuitableNodes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToUnsuitableNodes(Integer index, String item) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUnsuitableNodes(Integer index, String item) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUnsuitableNodes(String ... items) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.unsuitableNodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUnsuitableNodes(Collection<String> items) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.unsuitableNodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUnsuitableNodes(String ... items) {
        for (String item : items) {
            if (this.unsuitableNodes == null) continue;
            this.unsuitableNodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUnsuitableNodes(Collection<String> items) {
        for (String item : items) {
            if (this.unsuitableNodes == null) continue;
            this.unsuitableNodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUnsuitableNodes() {
        return this.unsuitableNodes;
    }

    @Override
    public String getUnsuitableNode(Integer index) {
        return this.unsuitableNodes.get(index);
    }

    @Override
    public String getFirstUnsuitableNode() {
        return this.unsuitableNodes.get(0);
    }

    @Override
    public String getLastUnsuitableNode() {
        return this.unsuitableNodes.get(this.unsuitableNodes.size() - 1);
    }

    @Override
    public String getMatchingUnsuitableNode(Predicate<String> predicate) {
        for (String item : this.unsuitableNodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUnsuitableNode(Predicate<String> predicate) {
        for (String item : this.unsuitableNodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUnsuitableNodes(List<String> unsuitableNodes) {
        if (unsuitableNodes != null) {
            this.unsuitableNodes = new ArrayList<String>();
            for (String item : unsuitableNodes) {
                this.addToUnsuitableNodes(item);
            }
        } else {
            this.unsuitableNodes = null;
        }
        return (A)this;
    }

    @Override
    public A withUnsuitableNodes(String ... unsuitableNodes) {
        if (this.unsuitableNodes != null) {
            this.unsuitableNodes.clear();
        }
        if (unsuitableNodes != null) {
            for (String item : unsuitableNodes) {
                this.addToUnsuitableNodes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUnsuitableNodes() {
        return this.unsuitableNodes != null && !this.unsuitableNodes.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceClaimSchedulingStatusFluentImpl that = (ResourceClaimSchedulingStatusFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.unsuitableNodes != null ? !this.unsuitableNodes.equals(that.unsuitableNodes) : that.unsuitableNodes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.unsuitableNodes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.unsuitableNodes != null && !this.unsuitableNodes.isEmpty()) {
            sb.append("unsuitableNodes:");
            sb.append(this.unsuitableNodes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

