package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceClaimSchedulingStatusFluentImpl<A extends ResourceClaimSchedulingStatusFluent<A>> extends BaseFluent<A> implements ResourceClaimSchedulingStatusFluent<A>{
  public ResourceClaimSchedulingStatusFluentImpl() {
  }
  public ResourceClaimSchedulingStatusFluentImpl(ResourceClaimSchedulingStatus instance) {
    if (instance != null) {
      this.withName(instance.getName());
      this.withUnsuitableNodes(instance.getUnsuitableNodes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String name;
  private List<String> unsuitableNodes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToUnsuitableNodes(int index,String item) {
    if (this.unsuitableNodes == null) {this.unsuitableNodes = new ArrayList<String>();}
    this.unsuitableNodes.add(index, item);
    return (A)this;
  }
  public A setToUnsuitableNodes(int index,String item) {
    if (this.unsuitableNodes == null) {this.unsuitableNodes = new ArrayList<String>();}
    this.unsuitableNodes.set(index, item); return (A)this;
  }
  public A addToUnsuitableNodes(java.lang.String... items) {
    if (this.unsuitableNodes == null) {this.unsuitableNodes = new ArrayList<String>();}
    for (String item : items) {this.unsuitableNodes.add(item);} return (A)this;
  }
  public A addAllToUnsuitableNodes(Collection<String> items) {
    if (this.unsuitableNodes == null) {this.unsuitableNodes = new ArrayList<String>();}
    for (String item : items) {this.unsuitableNodes.add(item);} return (A)this;
  }
  public A removeFromUnsuitableNodes(java.lang.String... items) {
    for (String item : items) {if (this.unsuitableNodes!= null){ this.unsuitableNodes.remove(item);}} return (A)this;
  }
  public A removeAllFromUnsuitableNodes(Collection<String> items) {
    for (String item : items) {if (this.unsuitableNodes!= null){ this.unsuitableNodes.remove(item);}} return (A)this;
  }
  public List<String> getUnsuitableNodes() {
    return this.unsuitableNodes;
  }
  public String getUnsuitableNode(int index) {
    return this.unsuitableNodes.get(index);
  }
  public String getFirstUnsuitableNode() {
    return this.unsuitableNodes.get(0);
  }
  public String getLastUnsuitableNode() {
    return this.unsuitableNodes.get(unsuitableNodes.size() - 1);
  }
  public String getMatchingUnsuitableNode(Predicate<String> predicate) {
    for (String item: unsuitableNodes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUnsuitableNode(Predicate<String> predicate) {
    for (String item: unsuitableNodes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUnsuitableNodes(List<String> unsuitableNodes) {
    if (unsuitableNodes != null) {this.unsuitableNodes = new ArrayList(); for (String item : unsuitableNodes){this.addToUnsuitableNodes(item);}} else { this.unsuitableNodes = null;} return (A) this;
  }
  public A withUnsuitableNodes(java.lang.String... unsuitableNodes) {
    if (this.unsuitableNodes != null) {this.unsuitableNodes.clear(); _visitables.remove("unsuitableNodes"); }
    if (unsuitableNodes != null) {for (String item :unsuitableNodes){ this.addToUnsuitableNodes(item);}} return (A) this;
  }
  public Boolean hasUnsuitableNodes() {
    return unsuitableNodes != null && !unsuitableNodes.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceClaimSchedulingStatusFluentImpl that = (ResourceClaimSchedulingStatusFluentImpl) o;
    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(unsuitableNodes, that.unsuitableNodes)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(name,  unsuitableNodes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (unsuitableNodes != null && !unsuitableNodes.isEmpty()) { sb.append("unsuitableNodes:"); sb.append(unsuitableNodes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}