package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSchedulingContextBuilder extends PodSchedulingContextFluent<PodSchedulingContextBuilder> implements VisitableBuilder<PodSchedulingContext,PodSchedulingContextBuilder>{
  public PodSchedulingContextBuilder() {
    this(false);
  }
  public PodSchedulingContextBuilder(Boolean validationEnabled) {
    this(new PodSchedulingContext(), validationEnabled);
  }
  public PodSchedulingContextBuilder(PodSchedulingContextFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSchedulingContextBuilder(PodSchedulingContextFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSchedulingContext(), validationEnabled);
  }
  public PodSchedulingContextBuilder(PodSchedulingContextFluent<?> fluent,PodSchedulingContext instance) {
    this(fluent, instance, false);
  }
  public PodSchedulingContextBuilder(PodSchedulingContextFluent<?> fluent,PodSchedulingContext instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSchedulingContext());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSchedulingContextBuilder(PodSchedulingContext instance) {
    this(instance,false);
  }
  public PodSchedulingContextBuilder(PodSchedulingContext instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSchedulingContext());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSchedulingContextFluent<?> fluent;
  Boolean validationEnabled;
  public PodSchedulingContext build() {
    PodSchedulingContext buildable = new PodSchedulingContext(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}