package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AllocationResultBuilder extends AllocationResultFluent<AllocationResultBuilder> implements VisitableBuilder<AllocationResult,AllocationResultBuilder>{
  public AllocationResultBuilder() {
    this(new AllocationResult());
  }
  
  public AllocationResultBuilder(AllocationResultFluent<?> fluent) {
    this(fluent, new AllocationResult());
  }
  
  public AllocationResultBuilder(AllocationResultFluent<?> fluent,AllocationResult instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AllocationResultBuilder(AllocationResult instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AllocationResultFluent<?> fluent;
  
  public AllocationResult build() {
    AllocationResult buildable = new AllocationResult(fluent.buildDevices(),fluent.getNodeSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}