package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceClaimConsumerReferenceBuilder extends ResourceClaimConsumerReferenceFluent<ResourceClaimConsumerReferenceBuilder> implements VisitableBuilder<ResourceClaimConsumerReference,ResourceClaimConsumerReferenceBuilder>{
  public ResourceClaimConsumerReferenceBuilder() {
    this(new ResourceClaimConsumerReference());
  }
  
  public ResourceClaimConsumerReferenceBuilder(ResourceClaimConsumerReferenceFluent<?> fluent) {
    this(fluent, new ResourceClaimConsumerReference());
  }
  
  public ResourceClaimConsumerReferenceBuilder(ResourceClaimConsumerReferenceFluent<?> fluent,ResourceClaimConsumerReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceClaimConsumerReferenceBuilder(ResourceClaimConsumerReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceClaimConsumerReferenceFluent<?> fluent;
  
  public ResourceClaimConsumerReference build() {
    ResourceClaimConsumerReference buildable = new ResourceClaimConsumerReference(fluent.getApiGroup(),fluent.getName(),fluent.getResource(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}