package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DeviceCounterConsumptionFluent<A extends DeviceCounterConsumptionFluent<A>> extends BaseFluent<A>{
  public DeviceCounterConsumptionFluent() {
  }
  
  public DeviceCounterConsumptionFluent(DeviceCounterConsumption instance) {
    this.copyInstance(instance);
  }
  private String counterSet;
  private Map<String,Counter> counters;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DeviceCounterConsumption instance) {
    instance = (instance != null ? instance : new DeviceCounterConsumption());
    if (instance != null) {
          this.withCounterSet(instance.getCounterSet());
          this.withCounters(instance.getCounters());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCounterSet() {
    return this.counterSet;
  }
  
  public A withCounterSet(String counterSet) {
    this.counterSet = counterSet;
    return (A) this;
  }
  
  public boolean hasCounterSet() {
    return this.counterSet != null;
  }
  
  public A addToCounters(String key,Counter value) {
    if(this.counters == null && key != null && value != null) { this.counters = new LinkedHashMap(); }
    if(key != null && value != null) {this.counters.put(key, value);} return (A)this;
  }
  
  public A addToCounters(Map<String,Counter> map) {
    if(this.counters == null && map != null) { this.counters = new LinkedHashMap(); }
    if(map != null) { this.counters.putAll(map);} return (A)this;
  }
  
  public A removeFromCounters(String key) {
    if(this.counters == null) { return (A) this; }
    if(key != null && this.counters != null) {this.counters.remove(key);} return (A)this;
  }
  
  public A removeFromCounters(Map<String,Counter> map) {
    if(this.counters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.counters != null){this.counters.remove(key);}}} return (A)this;
  }
  
  public Map<String,Counter> getCounters() {
    return this.counters;
  }
  
  public <K,V>A withCounters(Map<String,Counter> counters) {
    if (counters == null) {
      this.counters = null;
    } else {
      this.counters = new LinkedHashMap(counters);
    }
    return (A) this;
  }
  
  public boolean hasCounters() {
    return this.counters != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeviceCounterConsumptionFluent that = (DeviceCounterConsumptionFluent) o;
    if (!java.util.Objects.equals(counterSet, that.counterSet)) return false;
    if (!java.util.Objects.equals(counters, that.counters)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(counterSet,  counters,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (counterSet != null) { sb.append("counterSet:"); sb.append(counterSet + ","); }
    if (counters != null && !counters.isEmpty()) { sb.append("counters:"); sb.append(counters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}