package io.fabric8.kubernetes.api.model.resource.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.NodeSelector;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DeviceFluent<A extends DeviceFluent<A>> extends BaseFluent<A>{
  public DeviceFluent() {
  }
  
  public DeviceFluent(Device instance) {
    this.copyInstance(instance);
  }
  private Boolean allNodes;
  private Map<String,DeviceAttribute> attributes;
  private Map<String,DeviceCapacity> capacity;
  private ArrayList<DeviceCounterConsumptionBuilder> consumesCounters = new ArrayList<DeviceCounterConsumptionBuilder>();
  private String name;
  private String nodeName;
  private NodeSelector nodeSelector;
  private ArrayList<DeviceTaintBuilder> taints = new ArrayList<DeviceTaintBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Device instance) {
    instance = (instance != null ? instance : new Device());
    if (instance != null) {
          this.withAllNodes(instance.getAllNodes());
          this.withAttributes(instance.getAttributes());
          this.withCapacity(instance.getCapacity());
          this.withConsumesCounters(instance.getConsumesCounters());
          this.withName(instance.getName());
          this.withNodeName(instance.getNodeName());
          this.withNodeSelector(instance.getNodeSelector());
          this.withTaints(instance.getTaints());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getAllNodes() {
    return this.allNodes;
  }
  
  public A withAllNodes(Boolean allNodes) {
    this.allNodes = allNodes;
    return (A) this;
  }
  
  public boolean hasAllNodes() {
    return this.allNodes != null;
  }
  
  public A addToAttributes(String key,DeviceAttribute value) {
    if(this.attributes == null && key != null && value != null) { this.attributes = new LinkedHashMap(); }
    if(key != null && value != null) {this.attributes.put(key, value);} return (A)this;
  }
  
  public A addToAttributes(Map<String,DeviceAttribute> map) {
    if(this.attributes == null && map != null) { this.attributes = new LinkedHashMap(); }
    if(map != null) { this.attributes.putAll(map);} return (A)this;
  }
  
  public A removeFromAttributes(String key) {
    if(this.attributes == null) { return (A) this; }
    if(key != null && this.attributes != null) {this.attributes.remove(key);} return (A)this;
  }
  
  public A removeFromAttributes(Map<String,DeviceAttribute> map) {
    if(this.attributes == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.attributes != null){this.attributes.remove(key);}}} return (A)this;
  }
  
  public Map<String,DeviceAttribute> getAttributes() {
    return this.attributes;
  }
  
  public <K,V>A withAttributes(Map<String,DeviceAttribute> attributes) {
    if (attributes == null) {
      this.attributes = null;
    } else {
      this.attributes = new LinkedHashMap(attributes);
    }
    return (A) this;
  }
  
  public boolean hasAttributes() {
    return this.attributes != null;
  }
  
  public A addToCapacity(String key,DeviceCapacity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  
  public A addToCapacity(Map<String,DeviceCapacity> map) {
    if(this.capacity == null && map != null) { this.capacity = new LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  
  public A removeFromCapacity(String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  
  public A removeFromCapacity(Map<String,DeviceCapacity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  
  public Map<String,DeviceCapacity> getCapacity() {
    return this.capacity;
  }
  
  public <K,V>A withCapacity(Map<String,DeviceCapacity> capacity) {
    if (capacity == null) {
      this.capacity = null;
    } else {
      this.capacity = new LinkedHashMap(capacity);
    }
    return (A) this;
  }
  
  public boolean hasCapacity() {
    return this.capacity != null;
  }
  
  public A addToConsumesCounters(int index,DeviceCounterConsumption item) {
    if (this.consumesCounters == null) {this.consumesCounters = new ArrayList<DeviceCounterConsumptionBuilder>();}
    DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
    if (index < 0 || index >= consumesCounters.size()) {
        _visitables.get("consumesCounters").add(builder);
        consumesCounters.add(builder);
    } else {
        _visitables.get("consumesCounters").add(builder);
        consumesCounters.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConsumesCounters(int index,DeviceCounterConsumption item) {
    if (this.consumesCounters == null) {this.consumesCounters = new ArrayList<DeviceCounterConsumptionBuilder>();}
    DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
    if (index < 0 || index >= consumesCounters.size()) {
        _visitables.get("consumesCounters").add(builder);
        consumesCounters.add(builder);
    } else {
        _visitables.get("consumesCounters").add(builder);
        consumesCounters.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConsumesCounters(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceCounterConsumption... items) {
    if (this.consumesCounters == null) {this.consumesCounters = new ArrayList<DeviceCounterConsumptionBuilder>();}
    for (DeviceCounterConsumption item : items) {DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);_visitables.get("consumesCounters").add(builder);this.consumesCounters.add(builder);} return (A)this;
  }
  
  public A addAllToConsumesCounters(Collection<DeviceCounterConsumption> items) {
    if (this.consumesCounters == null) {this.consumesCounters = new ArrayList<DeviceCounterConsumptionBuilder>();}
    for (DeviceCounterConsumption item : items) {DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);_visitables.get("consumesCounters").add(builder);this.consumesCounters.add(builder);} return (A)this;
  }
  
  public A removeFromConsumesCounters(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceCounterConsumption... items) {
    if (this.consumesCounters == null) return (A)this;
    for (DeviceCounterConsumption item : items) {DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);_visitables.get("consumesCounters").remove(builder); this.consumesCounters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConsumesCounters(Collection<DeviceCounterConsumption> items) {
    if (this.consumesCounters == null) return (A)this;
    for (DeviceCounterConsumption item : items) {DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);_visitables.get("consumesCounters").remove(builder); this.consumesCounters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConsumesCounters(Predicate<DeviceCounterConsumptionBuilder> predicate) {
    if (consumesCounters == null) return (A) this;
    final Iterator<DeviceCounterConsumptionBuilder> each = consumesCounters.iterator();
    final List visitables = _visitables.get("consumesCounters");
    while (each.hasNext()) {
      DeviceCounterConsumptionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DeviceCounterConsumption> buildConsumesCounters() {
    return this.consumesCounters != null ? build(consumesCounters) : null;
  }
  
  public DeviceCounterConsumption buildConsumesCounter(int index) {
    return this.consumesCounters.get(index).build();
  }
  
  public DeviceCounterConsumption buildFirstConsumesCounter() {
    return this.consumesCounters.get(0).build();
  }
  
  public DeviceCounterConsumption buildLastConsumesCounter() {
    return this.consumesCounters.get(consumesCounters.size() - 1).build();
  }
  
  public DeviceCounterConsumption buildMatchingConsumesCounter(Predicate<DeviceCounterConsumptionBuilder> predicate) {
      for (DeviceCounterConsumptionBuilder item : consumesCounters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingConsumesCounter(Predicate<DeviceCounterConsumptionBuilder> predicate) {
      for (DeviceCounterConsumptionBuilder item : consumesCounters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConsumesCounters(List<DeviceCounterConsumption> consumesCounters) {
    if (this.consumesCounters != null) {
      this._visitables.get("consumesCounters").clear();
    }
    if (consumesCounters != null) {
        this.consumesCounters = new ArrayList();
        for (DeviceCounterConsumption item : consumesCounters) {
          this.addToConsumesCounters(item);
        }
    } else {
      this.consumesCounters = null;
    }
    return (A) this;
  }
  
  public A withConsumesCounters(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceCounterConsumption... consumesCounters) {
    if (this.consumesCounters != null) {
        this.consumesCounters.clear();
        _visitables.remove("consumesCounters");
    }
    if (consumesCounters != null) {
      for (DeviceCounterConsumption item : consumesCounters) {
        this.addToConsumesCounters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConsumesCounters() {
    return this.consumesCounters != null && !this.consumesCounters.isEmpty();
  }
  
  public ConsumesCountersNested<A> addNewConsumesCounter() {
    return new ConsumesCountersNested(-1, null);
  }
  
  public ConsumesCountersNested<A> addNewConsumesCounterLike(DeviceCounterConsumption item) {
    return new ConsumesCountersNested(-1, item);
  }
  
  public ConsumesCountersNested<A> setNewConsumesCounterLike(int index,DeviceCounterConsumption item) {
    return new ConsumesCountersNested(index, item);
  }
  
  public ConsumesCountersNested<A> editConsumesCounter(int index) {
    if (consumesCounters.size() <= index) throw new RuntimeException("Can't edit consumesCounters. Index exceeds size.");
    return setNewConsumesCounterLike(index, buildConsumesCounter(index));
  }
  
  public ConsumesCountersNested<A> editFirstConsumesCounter() {
    if (consumesCounters.size() == 0) throw new RuntimeException("Can't edit first consumesCounters. The list is empty.");
    return setNewConsumesCounterLike(0, buildConsumesCounter(0));
  }
  
  public ConsumesCountersNested<A> editLastConsumesCounter() {
    int index = consumesCounters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last consumesCounters. The list is empty.");
    return setNewConsumesCounterLike(index, buildConsumesCounter(index));
  }
  
  public ConsumesCountersNested<A> editMatchingConsumesCounter(Predicate<DeviceCounterConsumptionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<consumesCounters.size();i++) { 
    if (predicate.test(consumesCounters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching consumesCounters. No match found.");
    return setNewConsumesCounterLike(index, buildConsumesCounter(index));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getNodeName() {
    return this.nodeName;
  }
  
  public A withNodeName(String nodeName) {
    this.nodeName = nodeName;
    return (A) this;
  }
  
  public boolean hasNodeName() {
    return this.nodeName != null;
  }
  
  public NodeSelector getNodeSelector() {
    return this.nodeSelector;
  }
  
  public A withNodeSelector(NodeSelector nodeSelector) {
    this.nodeSelector = nodeSelector;
    return (A) this;
  }
  
  public boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  public A addToTaints(int index,DeviceTaint item) {
    if (this.taints == null) {this.taints = new ArrayList<DeviceTaintBuilder>();}
    DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
    if (index < 0 || index >= taints.size()) {
        _visitables.get("taints").add(builder);
        taints.add(builder);
    } else {
        _visitables.get("taints").add(builder);
        taints.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToTaints(int index,DeviceTaint item) {
    if (this.taints == null) {this.taints = new ArrayList<DeviceTaintBuilder>();}
    DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
    if (index < 0 || index >= taints.size()) {
        _visitables.get("taints").add(builder);
        taints.add(builder);
    } else {
        _visitables.get("taints").add(builder);
        taints.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToTaints(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceTaint... items) {
    if (this.taints == null) {this.taints = new ArrayList<DeviceTaintBuilder>();}
    for (DeviceTaint item : items) {DeviceTaintBuilder builder = new DeviceTaintBuilder(item);_visitables.get("taints").add(builder);this.taints.add(builder);} return (A)this;
  }
  
  public A addAllToTaints(Collection<DeviceTaint> items) {
    if (this.taints == null) {this.taints = new ArrayList<DeviceTaintBuilder>();}
    for (DeviceTaint item : items) {DeviceTaintBuilder builder = new DeviceTaintBuilder(item);_visitables.get("taints").add(builder);this.taints.add(builder);} return (A)this;
  }
  
  public A removeFromTaints(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceTaint... items) {
    if (this.taints == null) return (A)this;
    for (DeviceTaint item : items) {DeviceTaintBuilder builder = new DeviceTaintBuilder(item);_visitables.get("taints").remove(builder); this.taints.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTaints(Collection<DeviceTaint> items) {
    if (this.taints == null) return (A)this;
    for (DeviceTaint item : items) {DeviceTaintBuilder builder = new DeviceTaintBuilder(item);_visitables.get("taints").remove(builder); this.taints.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTaints(Predicate<DeviceTaintBuilder> predicate) {
    if (taints == null) return (A) this;
    final Iterator<DeviceTaintBuilder> each = taints.iterator();
    final List visitables = _visitables.get("taints");
    while (each.hasNext()) {
      DeviceTaintBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DeviceTaint> buildTaints() {
    return this.taints != null ? build(taints) : null;
  }
  
  public DeviceTaint buildTaint(int index) {
    return this.taints.get(index).build();
  }
  
  public DeviceTaint buildFirstTaint() {
    return this.taints.get(0).build();
  }
  
  public DeviceTaint buildLastTaint() {
    return this.taints.get(taints.size() - 1).build();
  }
  
  public DeviceTaint buildMatchingTaint(Predicate<DeviceTaintBuilder> predicate) {
      for (DeviceTaintBuilder item : taints) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTaint(Predicate<DeviceTaintBuilder> predicate) {
      for (DeviceTaintBuilder item : taints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTaints(List<DeviceTaint> taints) {
    if (this.taints != null) {
      this._visitables.get("taints").clear();
    }
    if (taints != null) {
        this.taints = new ArrayList();
        for (DeviceTaint item : taints) {
          this.addToTaints(item);
        }
    } else {
      this.taints = null;
    }
    return (A) this;
  }
  
  public A withTaints(io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceTaint... taints) {
    if (this.taints != null) {
        this.taints.clear();
        _visitables.remove("taints");
    }
    if (taints != null) {
      for (DeviceTaint item : taints) {
        this.addToTaints(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTaints() {
    return this.taints != null && !this.taints.isEmpty();
  }
  
  public A addNewTaint(String effect,String key,String timeAdded,String value) {
    return (A)addToTaints(new DeviceTaint(effect, key, timeAdded, value));
  }
  
  public TaintsNested<A> addNewTaint() {
    return new TaintsNested(-1, null);
  }
  
  public TaintsNested<A> addNewTaintLike(DeviceTaint item) {
    return new TaintsNested(-1, item);
  }
  
  public TaintsNested<A> setNewTaintLike(int index,DeviceTaint item) {
    return new TaintsNested(index, item);
  }
  
  public TaintsNested<A> editTaint(int index) {
    if (taints.size() <= index) throw new RuntimeException("Can't edit taints. Index exceeds size.");
    return setNewTaintLike(index, buildTaint(index));
  }
  
  public TaintsNested<A> editFirstTaint() {
    if (taints.size() == 0) throw new RuntimeException("Can't edit first taints. The list is empty.");
    return setNewTaintLike(0, buildTaint(0));
  }
  
  public TaintsNested<A> editLastTaint() {
    int index = taints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last taints. The list is empty.");
    return setNewTaintLike(index, buildTaint(index));
  }
  
  public TaintsNested<A> editMatchingTaint(Predicate<DeviceTaintBuilder> predicate) {
    int index = -1;
    for (int i=0;i<taints.size();i++) { 
    if (predicate.test(taints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching taints. No match found.");
    return setNewTaintLike(index, buildTaint(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeviceFluent that = (DeviceFluent) o;
    if (!java.util.Objects.equals(allNodes, that.allNodes)) return false;
    if (!java.util.Objects.equals(attributes, that.attributes)) return false;
    if (!java.util.Objects.equals(capacity, that.capacity)) return false;
    if (!java.util.Objects.equals(consumesCounters, that.consumesCounters)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(nodeName, that.nodeName)) return false;
    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;
    if (!java.util.Objects.equals(taints, that.taints)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allNodes,  attributes,  capacity,  consumesCounters,  name,  nodeName,  nodeSelector,  taints,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allNodes != null) { sb.append("allNodes:"); sb.append(allNodes + ","); }
    if (attributes != null && !attributes.isEmpty()) { sb.append("attributes:"); sb.append(attributes + ","); }
    if (capacity != null && !capacity.isEmpty()) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (consumesCounters != null && !consumesCounters.isEmpty()) { sb.append("consumesCounters:"); sb.append(consumesCounters + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (nodeSelector != null) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (taints != null && !taints.isEmpty()) { sb.append("taints:"); sb.append(taints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAllNodes() {
    return withAllNodes(true);
  }
  public class ConsumesCountersNested<N> extends DeviceCounterConsumptionFluent<ConsumesCountersNested<N>> implements Nested<N>{
    ConsumesCountersNested(int index,DeviceCounterConsumption item) {
      this.index = index;
      this.builder = new DeviceCounterConsumptionBuilder(this, item);
    }
    DeviceCounterConsumptionBuilder builder;
    int index;
    
    public N and() {
      return (N) DeviceFluent.this.setToConsumesCounters(index,builder.build());
    }
    
    public N endConsumesCounter() {
      return and();
    }
    
  
  }
  public class TaintsNested<N> extends DeviceTaintFluent<TaintsNested<N>> implements Nested<N>{
    TaintsNested(int index,DeviceTaint item) {
      this.index = index;
      this.builder = new DeviceTaintBuilder(this, item);
    }
    DeviceTaintBuilder builder;
    int index;
    
    public N and() {
      return (N) DeviceFluent.this.setToTaints(index,builder.build());
    }
    
    public N endTaint() {
      return and();
    }
    
  
  }

}