package io.fabric8.kubernetes.api.model.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PriorityClassBuilder extends PriorityClassFluent<PriorityClassBuilder> implements VisitableBuilder<PriorityClass,PriorityClassBuilder>{
  public PriorityClassBuilder() {
    this(false);
  }
  public PriorityClassBuilder(Boolean validationEnabled) {
    this(new PriorityClass(), validationEnabled);
  }
  public PriorityClassBuilder(PriorityClassFluent<?> fluent) {
    this(fluent, false);
  }
  public PriorityClassBuilder(PriorityClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PriorityClass(), validationEnabled);
  }
  public PriorityClassBuilder(PriorityClassFluent<?> fluent,PriorityClass instance) {
    this(fluent, instance, false);
  }
  public PriorityClassBuilder(PriorityClassFluent<?> fluent,PriorityClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PriorityClass());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDescription(instance.getDescription());
      fluent.withGlobalDefault(instance.getGlobalDefault());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withPreemptionPolicy(instance.getPreemptionPolicy());
      fluent.withValue(instance.getValue());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDescription(instance.getDescription());
      fluent.withGlobalDefault(instance.getGlobalDefault());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withPreemptionPolicy(instance.getPreemptionPolicy());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PriorityClassBuilder(PriorityClass instance) {
    this(instance,false);
  }
  public PriorityClassBuilder(PriorityClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PriorityClass());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withDescription(instance.getDescription());
      this.withGlobalDefault(instance.getGlobalDefault());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withPreemptionPolicy(instance.getPreemptionPolicy());
      this.withValue(instance.getValue());
      this.withApiVersion(instance.getApiVersion());
      this.withDescription(instance.getDescription());
      this.withGlobalDefault(instance.getGlobalDefault());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withPreemptionPolicy(instance.getPreemptionPolicy());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PriorityClassFluent<?> fluent;
  Boolean validationEnabled;
  public PriorityClass build() {
    PriorityClass buildable = new PriorityClass(fluent.getApiVersion(),fluent.getDescription(),fluent.getGlobalDefault(),fluent.getKind(),fluent.buildMetadata(),fluent.getPreemptionPolicy(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}