package io.fabric8.kubernetes.api.model.settings;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Volume;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface PodPresetSpecFluent<A extends PodPresetSpecFluent<A>> extends Fluent<A> {


    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public List<EnvVar> getEnv();
    public EnvVar getEnv(int index);
    public EnvVar getFirstEnv();
    public EnvVar getLastEnv();
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate);
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public A addToEnvFrom(int index,EnvFromSource item);
    public A setToEnvFrom(int index,EnvFromSource item);
    public A addToEnvFrom(EnvFromSource... items);
    public A addAllToEnvFrom(Collection<EnvFromSource> items);
    public A removeFromEnvFrom(EnvFromSource... items);
    public A removeAllFromEnvFrom(Collection<EnvFromSource> items);
    public List<EnvFromSource> getEnvFrom();
    public EnvFromSource getEnvFrom(int index);
    public EnvFromSource getFirstEnvFrom();
    public EnvFromSource getLastEnvFrom();
    public EnvFromSource getMatchingEnvFrom(Predicate<EnvFromSource> predicate);
    public Boolean hasMatchingEnvFrom(Predicate<EnvFromSource> predicate);
    public A withEnvFrom(List<EnvFromSource> envFrom);
    public A withEnvFrom(EnvFromSource... envFrom);
    public Boolean hasEnvFrom();
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public PodPresetSpecFluent.SelectorNested<A> withNewSelector();
    public PodPresetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public PodPresetSpecFluent.SelectorNested<A> editSelector();
    public PodPresetSpecFluent.SelectorNested<A> editOrNewSelector();
    public PodPresetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    public A addToVolumeMounts(int index,VolumeMount item);
    public A setToVolumeMounts(int index,VolumeMount item);
    public A addToVolumeMounts(VolumeMount... items);
    public A addAllToVolumeMounts(Collection<VolumeMount> items);
    public A removeFromVolumeMounts(VolumeMount... items);
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items);
    public List<VolumeMount> getVolumeMounts();
    public VolumeMount getVolumeMount(int index);
    public VolumeMount getFirstVolumeMount();
    public VolumeMount getLastVolumeMount();
    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate);
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate);
    public A withVolumeMounts(List<VolumeMount> volumeMounts);
    public A withVolumeMounts(VolumeMount... volumeMounts);
    public Boolean hasVolumeMounts();
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    public List<Volume> getVolumes();
    public Volume getVolume(int index);
    public Volume getFirstVolume();
    public Volume getLastVolume();
    public Volume getMatchingVolume(Predicate<Volume> predicate);
    public Boolean hasMatchingVolume(Predicate<Volume> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PodPresetSpecFluent.SelectorNested<N>> {

        public N and();
        public N endSelector();    }


}
