package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface VolumeAttachmentListFluent<A extends VolumeAttachmentListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,VolumeAttachment item);
    public A setToItems(int index,VolumeAttachment item);
    public A addToItems(VolumeAttachment... items);
    public A addAllToItems(Collection<VolumeAttachment> items);
    public A removeFromItems(VolumeAttachment... items);
    public A removeAllFromItems(Collection<VolumeAttachment> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<VolumeAttachmentBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<VolumeAttachment> getItems();
    public List<VolumeAttachment> buildItems();
    public VolumeAttachment buildItem(int index);
    public VolumeAttachment buildFirstItem();
    public VolumeAttachment buildLastItem();
    public VolumeAttachment buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<VolumeAttachmentBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<VolumeAttachmentBuilder> predicate);
    public A withItems(List<VolumeAttachment> items);
    public A withItems(VolumeAttachment... items);
    public Boolean hasItems();
    public VolumeAttachmentListFluent.ItemsNested<A> addNewItem();
    public VolumeAttachmentListFluent.ItemsNested<A> addNewItemLike(VolumeAttachment item);
    public VolumeAttachmentListFluent.ItemsNested<A> setNewItemLike(int index,VolumeAttachment item);
    public VolumeAttachmentListFluent.ItemsNested<A> editItem(int index);
    public VolumeAttachmentListFluent.ItemsNested<A> editFirstItem();
    public VolumeAttachmentListFluent.ItemsNested<A> editLastItem();
    public VolumeAttachmentListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<VolumeAttachmentBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeAttachmentFluent<VolumeAttachmentListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
