package io.fabric8.kubernetes.api.model.storage.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CSIDriverSpecFluentImpl<A extends CSIDriverSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CSIDriverSpecFluent<A> {

    private Boolean attachRequired;
    private String fsGroupPolicy;
    private Boolean podInfoOnMount;
    private Boolean storageCapacity;
    private List<String> volumeLifecycleModes = new ArrayList<String>();

    public CSIDriverSpecFluentImpl() { 
    }


    public CSIDriverSpecFluentImpl(CSIDriverSpec instance) { 
        this.withAttachRequired(instance.getAttachRequired()); 
        this.withFsGroupPolicy(instance.getFsGroupPolicy()); 
        this.withPodInfoOnMount(instance.getPodInfoOnMount()); 
        this.withStorageCapacity(instance.getStorageCapacity()); 
        this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes()); 
    }


    public Boolean isAttachRequired() {
        return this.attachRequired;
    }

    public A withAttachRequired(Boolean attachRequired) {
        this.attachRequired=attachRequired; return (A) this;
    }

    public Boolean hasAttachRequired() {
        return this.attachRequired != null;
    }

    public A withNewAttachRequired(String arg1) {
        return (A)withAttachRequired(new Boolean(arg1));
    }

    public A withNewAttachRequired(boolean arg1) {
        return (A)withAttachRequired(new Boolean(arg1));
    }

    public String getFsGroupPolicy() {
        return this.fsGroupPolicy;
    }

    public A withFsGroupPolicy(String fsGroupPolicy) {
        this.fsGroupPolicy=fsGroupPolicy; return (A) this;
    }

    public Boolean hasFsGroupPolicy() {
        return this.fsGroupPolicy != null;
    }

    public A withNewFsGroupPolicy(String arg1) {
        return (A)withFsGroupPolicy(new String(arg1));
    }

    public A withNewFsGroupPolicy(StringBuilder arg1) {
        return (A)withFsGroupPolicy(new String(arg1));
    }

    public A withNewFsGroupPolicy(StringBuffer arg1) {
        return (A)withFsGroupPolicy(new String(arg1));
    }

    public Boolean isPodInfoOnMount() {
        return this.podInfoOnMount;
    }

    public A withPodInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount=podInfoOnMount; return (A) this;
    }

    public Boolean hasPodInfoOnMount() {
        return this.podInfoOnMount != null;
    }

    public A withNewPodInfoOnMount(String arg1) {
        return (A)withPodInfoOnMount(new Boolean(arg1));
    }

    public A withNewPodInfoOnMount(boolean arg1) {
        return (A)withPodInfoOnMount(new Boolean(arg1));
    }

    public Boolean isStorageCapacity() {
        return this.storageCapacity;
    }

    public A withStorageCapacity(Boolean storageCapacity) {
        this.storageCapacity=storageCapacity; return (A) this;
    }

    public Boolean hasStorageCapacity() {
        return this.storageCapacity != null;
    }

    public A withNewStorageCapacity(String arg1) {
        return (A)withStorageCapacity(new Boolean(arg1));
    }

    public A withNewStorageCapacity(boolean arg1) {
        return (A)withStorageCapacity(new Boolean(arg1));
    }

    public A addToVolumeLifecycleModes(int index,String item) {
        if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
        this.volumeLifecycleModes.add(index, item);
        return (A)this;
    }

    public A setToVolumeLifecycleModes(int index,String item) {
        if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
        this.volumeLifecycleModes.set(index, item); return (A)this;
    }

    public A addToVolumeLifecycleModes(String... items) {
        if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
        for (String item : items) {this.volumeLifecycleModes.add(item);} return (A)this;
    }

    public A addAllToVolumeLifecycleModes(Collection<String> items) {
        if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
        for (String item : items) {this.volumeLifecycleModes.add(item);} return (A)this;
    }

    public A removeFromVolumeLifecycleModes(String... items) {
        for (String item : items) {if (this.volumeLifecycleModes!= null){ this.volumeLifecycleModes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumeLifecycleModes(Collection<String> items) {
        for (String item : items) {if (this.volumeLifecycleModes!= null){ this.volumeLifecycleModes.remove(item);}} return (A)this;
    }

    public List<String> getVolumeLifecycleModes() {
        return this.volumeLifecycleModes;
    }

    public String getVolumeLifecycleMode(int index) {
        return this.volumeLifecycleModes.get(index);
    }

    public String getFirstVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(0);
    }

    public String getLastVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(volumeLifecycleModes.size() - 1);
    }

    public String getMatchingVolumeLifecycleMode(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: volumeLifecycleModes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolumeLifecycleMode(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: volumeLifecycleModes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumeLifecycleModes(List<String> volumeLifecycleModes) {
        if (this.volumeLifecycleModes != null) { _visitables.get("volumeLifecycleModes").removeAll(this.volumeLifecycleModes);}
        if (volumeLifecycleModes != null) {this.volumeLifecycleModes = new ArrayList<String>(); for (String item : volumeLifecycleModes){this.addToVolumeLifecycleModes(item);}} else { this.volumeLifecycleModes = null;} return (A) this;
    }

    public A withVolumeLifecycleModes(String... volumeLifecycleModes) {
        if (this.volumeLifecycleModes != null) {this.volumeLifecycleModes.clear();}
        if (volumeLifecycleModes != null) {for (String item :volumeLifecycleModes){ this.addToVolumeLifecycleModes(item);}} return (A) this;
    }

    public Boolean hasVolumeLifecycleModes() {
        return volumeLifecycleModes != null && !volumeLifecycleModes.isEmpty();
    }

    public A addNewVolumeLifecycleMode(String arg1) {
        return (A)addToVolumeLifecycleModes(new String(arg1));
    }

    public A addNewVolumeLifecycleMode(StringBuilder arg1) {
        return (A)addToVolumeLifecycleModes(new String(arg1));
    }

    public A addNewVolumeLifecycleMode(StringBuffer arg1) {
        return (A)addToVolumeLifecycleModes(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CSIDriverSpecFluentImpl that = (CSIDriverSpecFluentImpl) o;
        if (attachRequired != null ? !attachRequired.equals(that.attachRequired) :that.attachRequired != null) return false;
        if (fsGroupPolicy != null ? !fsGroupPolicy.equals(that.fsGroupPolicy) :that.fsGroupPolicy != null) return false;
        if (podInfoOnMount != null ? !podInfoOnMount.equals(that.podInfoOnMount) :that.podInfoOnMount != null) return false;
        if (storageCapacity != null ? !storageCapacity.equals(that.storageCapacity) :that.storageCapacity != null) return false;
        if (volumeLifecycleModes != null ? !volumeLifecycleModes.equals(that.volumeLifecycleModes) :that.volumeLifecycleModes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(attachRequired,  fsGroupPolicy,  podInfoOnMount,  storageCapacity,  volumeLifecycleModes,  super.hashCode());
    }

}
