package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeAttachmentSourceBuilder extends VolumeAttachmentSourceFluentImpl<VolumeAttachmentSourceBuilder> implements VisitableBuilder<VolumeAttachmentSource,VolumeAttachmentSourceBuilder> {

    VolumeAttachmentSourceFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeAttachmentSourceBuilder() { 
        this(true);
    }


    public VolumeAttachmentSourceBuilder(Boolean validationEnabled) { 
        this(new VolumeAttachmentSource(), validationEnabled);
    }


    public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new VolumeAttachmentSource(), validationEnabled);
    }


    public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent,VolumeAttachmentSource instance) { 
        this(fluent, instance, true);
    }


    public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent,VolumeAttachmentSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withInlineVolumeSpec(instance.getInlineVolumeSpec()); 
        fluent.withPersistentVolumeName(instance.getPersistentVolumeName()); 
        this.validationEnabled = validationEnabled; 
    }


    public VolumeAttachmentSourceBuilder(VolumeAttachmentSource instance) { 
        this(instance,true);
    }


    public VolumeAttachmentSourceBuilder(VolumeAttachmentSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withInlineVolumeSpec(instance.getInlineVolumeSpec()); 
        this.withPersistentVolumeName(instance.getPersistentVolumeName()); 
        this.validationEnabled = validationEnabled; 
    }


    public VolumeAttachmentSource build() {
        VolumeAttachmentSource buildable = new VolumeAttachmentSource(fluent.getInlineVolumeSpec(),fluent.getPersistentVolumeName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VolumeAttachmentSourceBuilder that = (VolumeAttachmentSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
