package io.fabric8.kubernetes.api.model.storage.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CSINodeDriverFluentImpl<A extends CSINodeDriverFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CSINodeDriverFluent<A> {

    private VolumeNodeResourcesBuilder allocatable;
    private String name;
    private String nodeID;
    private List<String> topologyKeys = new ArrayList<String>();

    public CSINodeDriverFluentImpl() { 
    }


    public CSINodeDriverFluentImpl(CSINodeDriver instance) { 
        this.withAllocatable(instance.getAllocatable()); 
        this.withName(instance.getName()); 
        this.withNodeID(instance.getNodeID()); 
        this.withTopologyKeys(instance.getTopologyKeys()); 
    }


    
/**
 * This method has been deprecated, please use method buildAllocatable instead.
 * @return The buildable object.
 */
@Deprecated public VolumeNodeResources getAllocatable() {
        return this.allocatable!=null?this.allocatable.build():null;
    }

    public VolumeNodeResources buildAllocatable() {
        return this.allocatable!=null?this.allocatable.build():null;
    }

    public A withAllocatable(VolumeNodeResources allocatable) {
        _visitables.get("allocatable").remove(this.allocatable);
        if (allocatable!=null){ this.allocatable= new VolumeNodeResourcesBuilder(allocatable); _visitables.get("allocatable").add(this.allocatable);} return (A) this;
    }

    public Boolean hasAllocatable() {
        return this.allocatable != null;
    }

    public A withNewAllocatable(Integer count) {
        return (A)withAllocatable(new VolumeNodeResources(count));
    }

    public CSINodeDriverFluent.AllocatableNested<A> withNewAllocatable() {
        return new AllocatableNestedImpl();
    }

    public CSINodeDriverFluent.AllocatableNested<A> withNewAllocatableLike(VolumeNodeResources item) {
        return new AllocatableNestedImpl(item);
    }

    public CSINodeDriverFluent.AllocatableNested<A> editAllocatable() {
        return withNewAllocatableLike(getAllocatable());
    }

    public CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatable() {
        return withNewAllocatableLike(getAllocatable() != null ? getAllocatable(): new VolumeNodeResourcesBuilder().build());
    }

    public CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatableLike(VolumeNodeResources item) {
        return withNewAllocatableLike(getAllocatable() != null ? getAllocatable(): item);
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public A withNodeID(String nodeID) {
        this.nodeID=nodeID; return (A) this;
    }

    public Boolean hasNodeID() {
        return this.nodeID != null;
    }

    public A withNewNodeID(String arg1) {
        return (A)withNodeID(new String(arg1));
    }

    public A withNewNodeID(StringBuilder arg1) {
        return (A)withNodeID(new String(arg1));
    }

    public A withNewNodeID(StringBuffer arg1) {
        return (A)withNodeID(new String(arg1));
    }

    public A addToTopologyKeys(int index,String item) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        this.topologyKeys.add(index, item);
        return (A)this;
    }

    public A setToTopologyKeys(int index,String item) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        this.topologyKeys.set(index, item); return (A)this;
    }

    public A addToTopologyKeys(String... items) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        for (String item : items) {this.topologyKeys.add(item);} return (A)this;
    }

    public A addAllToTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        for (String item : items) {this.topologyKeys.add(item);} return (A)this;
    }

    public A removeFromTopologyKeys(String... items) {
        for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
    }

    public A removeAllFromTopologyKeys(Collection<String> items) {
        for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
    }

    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    public String getTopologyKey(int index) {
        return this.topologyKeys.get(index);
    }

    public String getFirstTopologyKey() {
        return this.topologyKeys.get(0);
    }

    public String getLastTopologyKey() {
        return this.topologyKeys.get(topologyKeys.size() - 1);
    }

    public String getMatchingTopologyKey(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: topologyKeys) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTopologyKey(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: topologyKeys) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTopologyKeys(List<String> topologyKeys) {
        if (this.topologyKeys != null) { _visitables.get("topologyKeys").removeAll(this.topologyKeys);}
        if (topologyKeys != null) {this.topologyKeys = new ArrayList<String>(); for (String item : topologyKeys){this.addToTopologyKeys(item);}} else { this.topologyKeys = null;} return (A) this;
    }

    public A withTopologyKeys(String... topologyKeys) {
        if (this.topologyKeys != null) {this.topologyKeys.clear();}
        if (topologyKeys != null) {for (String item :topologyKeys){ this.addToTopologyKeys(item);}} return (A) this;
    }

    public Boolean hasTopologyKeys() {
        return topologyKeys != null && !topologyKeys.isEmpty();
    }

    public A addNewTopologyKey(String arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(StringBuilder arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(StringBuffer arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CSINodeDriverFluentImpl that = (CSINodeDriverFluentImpl) o;
        if (allocatable != null ? !allocatable.equals(that.allocatable) :that.allocatable != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (nodeID != null ? !nodeID.equals(that.nodeID) :that.nodeID != null) return false;
        if (topologyKeys != null ? !topologyKeys.equals(that.topologyKeys) :that.topologyKeys != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allocatable,  name,  nodeID,  topologyKeys,  super.hashCode());
    }

    public class AllocatableNestedImpl<N> extends VolumeNodeResourcesFluentImpl<CSINodeDriverFluent.AllocatableNested<N>> implements CSINodeDriverFluent.AllocatableNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeNodeResourcesBuilder builder;

        AllocatableNestedImpl(VolumeNodeResources item) {
            this.builder = new VolumeNodeResourcesBuilder(this, item);
        }

        AllocatableNestedImpl() {
            this.builder = new VolumeNodeResourcesBuilder(this);
        }

        public N and() {
             return (N) CSINodeDriverFluentImpl.this.withAllocatable(builder.build());
        }

        public N endAllocatable() {
             return and();
        }
    }


}
