package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.TopologySelectorTerm;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class StorageClassFluentImpl<A extends io.fabric8.kubernetes.api.model.storage.StorageClassFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.storage.StorageClassFluent<A>{
  public StorageClassFluentImpl() {
  }
  public StorageClassFluentImpl(io.fabric8.kubernetes.api.model.storage.StorageClass instance) {
    this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion()); 
    this.withAllowedTopologies(instance.getAllowedTopologies()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withMountOptions(instance.getMountOptions()); 
    this.withParameters(instance.getParameters()); 
    this.withProvisioner(instance.getProvisioner()); 
    this.withReclaimPolicy(instance.getReclaimPolicy()); 
    this.withVolumeBindingMode(instance.getVolumeBindingMode()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.Boolean allowVolumeExpansion;
  private java.util.List<io.fabric8.kubernetes.api.model.TopologySelectorTerm> allowedTopologies = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySelectorTerm>();
  private java.lang.String apiVersion;
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.util.List<java.lang.String> mountOptions = new java.util.ArrayList<java.lang.String>();
  private java.util.Map<java.lang.String,java.lang.String> parameters;
  private java.lang.String provisioner;
  private java.lang.String reclaimPolicy;
  private java.lang.String volumeBindingMode;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.Boolean getAllowVolumeExpansion() {
    return this.allowVolumeExpansion;
  }
  public A withAllowVolumeExpansion(java.lang.Boolean allowVolumeExpansion) {
    this.allowVolumeExpansion=allowVolumeExpansion; return (A) this;
  }
  public java.lang.Boolean hasAllowVolumeExpansion() {
    return this.allowVolumeExpansion != null;
  }
  public A addToAllowedTopologies(java.lang.Integer index,io.fabric8.kubernetes.api.model.TopologySelectorTerm item) {
    if (this.allowedTopologies == null) {this.allowedTopologies = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySelectorTerm>();}
    this.allowedTopologies.add(index, item);
    return (A)this;
  }
  public A setToAllowedTopologies(java.lang.Integer index,io.fabric8.kubernetes.api.model.TopologySelectorTerm item) {
    if (this.allowedTopologies == null) {this.allowedTopologies = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySelectorTerm>();}
    this.allowedTopologies.set(index, item); return (A)this;
  }
  public A addToAllowedTopologies(io.fabric8.kubernetes.api.model.TopologySelectorTerm... items) {
    if (this.allowedTopologies == null) {this.allowedTopologies = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySelectorTerm>();}
    for (io.fabric8.kubernetes.api.model.TopologySelectorTerm item : items) {this.allowedTopologies.add(item);} return (A)this;
  }
  public A addAllToAllowedTopologies(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySelectorTerm> items) {
    if (this.allowedTopologies == null) {this.allowedTopologies = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySelectorTerm>();}
    for (io.fabric8.kubernetes.api.model.TopologySelectorTerm item : items) {this.allowedTopologies.add(item);} return (A)this;
  }
  public A removeFromAllowedTopologies(io.fabric8.kubernetes.api.model.TopologySelectorTerm... items) {
    for (io.fabric8.kubernetes.api.model.TopologySelectorTerm item : items) {if (this.allowedTopologies!= null){ this.allowedTopologies.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedTopologies(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySelectorTerm> items) {
    for (io.fabric8.kubernetes.api.model.TopologySelectorTerm item : items) {if (this.allowedTopologies!= null){ this.allowedTopologies.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.TopologySelectorTerm> getAllowedTopologies() {
    return this.allowedTopologies;
  }
  public io.fabric8.kubernetes.api.model.TopologySelectorTerm getAllowedTopology(java.lang.Integer index) {
    return this.allowedTopologies.get(index);
  }
  public io.fabric8.kubernetes.api.model.TopologySelectorTerm getFirstAllowedTopology() {
    return this.allowedTopologies.get(0);
  }
  public io.fabric8.kubernetes.api.model.TopologySelectorTerm getLastAllowedTopology() {
    return this.allowedTopologies.get(allowedTopologies.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.TopologySelectorTerm getMatchingAllowedTopology(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySelectorTerm> predicate) {
    for (io.fabric8.kubernetes.api.model.TopologySelectorTerm item: allowedTopologies) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAllowedTopology(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySelectorTerm> predicate) {
    for (io.fabric8.kubernetes.api.model.TopologySelectorTerm item: allowedTopologies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedTopologies(java.util.List<io.fabric8.kubernetes.api.model.TopologySelectorTerm> allowedTopologies) {
    if (allowedTopologies != null) {this.allowedTopologies = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySelectorTerm>(); for (io.fabric8.kubernetes.api.model.TopologySelectorTerm item : allowedTopologies){this.addToAllowedTopologies(item);}} else { this.allowedTopologies = null;} return (A) this;
  }
  public A withAllowedTopologies(io.fabric8.kubernetes.api.model.TopologySelectorTerm... allowedTopologies) {
    if (this.allowedTopologies != null) {this.allowedTopologies.clear();}
    if (allowedTopologies != null) {for (io.fabric8.kubernetes.api.model.TopologySelectorTerm item :allowedTopologies){ this.addToAllowedTopologies(item);}} return (A) this;
  }
  public java.lang.Boolean hasAllowedTopologies() {
    return allowedTopologies != null && !allowedTopologies.isEmpty();
  }
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.kubernetes.api.model.storage.StorageClassFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.kubernetes.api.model.storage.StorageClassFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.storage.StorageClassFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.kubernetes.api.model.storage.StorageClassFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.storage.StorageClassFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.storage.StorageClassFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.storage.StorageClassFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToMountOptions(java.lang.Integer index,java.lang.String item) {
    if (this.mountOptions == null) {this.mountOptions = new java.util.ArrayList<java.lang.String>();}
    this.mountOptions.add(index, item);
    return (A)this;
  }
  public A setToMountOptions(java.lang.Integer index,java.lang.String item) {
    if (this.mountOptions == null) {this.mountOptions = new java.util.ArrayList<java.lang.String>();}
    this.mountOptions.set(index, item); return (A)this;
  }
  public A addToMountOptions(java.lang.String... items) {
    if (this.mountOptions == null) {this.mountOptions = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.mountOptions.add(item);} return (A)this;
  }
  public A addAllToMountOptions(java.util.Collection<java.lang.String> items) {
    if (this.mountOptions == null) {this.mountOptions = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.mountOptions.add(item);} return (A)this;
  }
  public A removeFromMountOptions(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.mountOptions!= null){ this.mountOptions.remove(item);}} return (A)this;
  }
  public A removeAllFromMountOptions(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.mountOptions!= null){ this.mountOptions.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getMountOptions() {
    return this.mountOptions;
  }
  public java.lang.String getMountOption(java.lang.Integer index) {
    return this.mountOptions.get(index);
  }
  public java.lang.String getFirstMountOption() {
    return this.mountOptions.get(0);
  }
  public java.lang.String getLastMountOption() {
    return this.mountOptions.get(mountOptions.size() - 1);
  }
  public java.lang.String getMatchingMountOption(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: mountOptions) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingMountOption(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: mountOptions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMountOptions(java.util.List<java.lang.String> mountOptions) {
    if (mountOptions != null) {this.mountOptions = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : mountOptions){this.addToMountOptions(item);}} else { this.mountOptions = null;} return (A) this;
  }
  public A withMountOptions(java.lang.String... mountOptions) {
    if (this.mountOptions != null) {this.mountOptions.clear();}
    if (mountOptions != null) {for (java.lang.String item :mountOptions){ this.addToMountOptions(item);}} return (A) this;
  }
  public java.lang.Boolean hasMountOptions() {
    return mountOptions != null && !mountOptions.isEmpty();
  }
  public A addNewMountOption(java.lang.String arg0) {
    return (A)addToMountOptions(new String(arg0));
  }
  public A addToParameters(java.lang.String key,java.lang.String value) {
    if(this.parameters == null && key != null && value != null) { this.parameters = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(key != null && value != null) {this.parameters.put(key, value);} return (A)this;
  }
  public A addToParameters(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.parameters == null && map != null) { this.parameters = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
    if(map != null) { this.parameters.putAll(map);} return (A)this;
  }
  public A removeFromParameters(java.lang.String key) {
    if(this.parameters == null) { return (A) this; }
    if(key != null && this.parameters != null) {this.parameters.remove(key);} return (A)this;
  }
  public A removeFromParameters(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.parameters == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.parameters != null){this.parameters.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getParameters() {
    return this.parameters;
  }
  public <K,V>A withParameters(java.util.Map<java.lang.String,java.lang.String> parameters) {
    if (parameters == null) { this.parameters =  null;} else {this.parameters = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(parameters);} return (A) this;
  }
  public java.lang.Boolean hasParameters() {
    return this.parameters != null;
  }
  public java.lang.String getProvisioner() {
    return this.provisioner;
  }
  public A withProvisioner(java.lang.String provisioner) {
    this.provisioner=provisioner; return (A) this;
  }
  public java.lang.Boolean hasProvisioner() {
    return this.provisioner != null;
  }
  
  /**
   * Method is deprecated. use withProvisioner instead.
   */
  @java.lang.Deprecated
  public A withNewProvisioner(java.lang.String arg0) {
    return (A)withProvisioner(new String(arg0));
  }
  public java.lang.String getReclaimPolicy() {
    return this.reclaimPolicy;
  }
  public A withReclaimPolicy(java.lang.String reclaimPolicy) {
    this.reclaimPolicy=reclaimPolicy; return (A) this;
  }
  public java.lang.Boolean hasReclaimPolicy() {
    return this.reclaimPolicy != null;
  }
  
  /**
   * Method is deprecated. use withReclaimPolicy instead.
   */
  @java.lang.Deprecated
  public A withNewReclaimPolicy(java.lang.String arg0) {
    return (A)withReclaimPolicy(new String(arg0));
  }
  public java.lang.String getVolumeBindingMode() {
    return this.volumeBindingMode;
  }
  public A withVolumeBindingMode(java.lang.String volumeBindingMode) {
    this.volumeBindingMode=volumeBindingMode; return (A) this;
  }
  public java.lang.Boolean hasVolumeBindingMode() {
    return this.volumeBindingMode != null;
  }
  
  /**
   * Method is deprecated. use withVolumeBindingMode instead.
   */
  @java.lang.Deprecated
  public A withNewVolumeBindingMode(java.lang.String arg0) {
    return (A)withVolumeBindingMode(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StorageClassFluentImpl that = (StorageClassFluentImpl) o;
    if (allowVolumeExpansion != null ? !allowVolumeExpansion.equals(that.allowVolumeExpansion) :that.allowVolumeExpansion != null) return false;
    if (allowedTopologies != null ? !allowedTopologies.equals(that.allowedTopologies) :that.allowedTopologies != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (mountOptions != null ? !mountOptions.equals(that.mountOptions) :that.mountOptions != null) return false;
    if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
    if (provisioner != null ? !provisioner.equals(that.provisioner) :that.provisioner != null) return false;
    if (reclaimPolicy != null ? !reclaimPolicy.equals(that.reclaimPolicy) :that.reclaimPolicy != null) return false;
    if (volumeBindingMode != null ? !volumeBindingMode.equals(that.volumeBindingMode) :that.volumeBindingMode != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowVolumeExpansion,  allowedTopologies,  apiVersion,  kind,  metadata,  mountOptions,  parameters,  provisioner,  reclaimPolicy,  volumeBindingMode,  additionalProperties,  super.hashCode());
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.storage.StorageClassFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.storage.StorageClassFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) StorageClassFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}