package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class CSIStorageCapacityFluentImpl<A extends io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent<A>{
  public CSIStorageCapacityFluentImpl() {
  }
  public CSIStorageCapacityFluentImpl(io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withCapacity(instance.getCapacity()); 
    this.withKind(instance.getKind()); 
    this.withMaximumVolumeSize(instance.getMaximumVolumeSize()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNodeTopology(instance.getNodeTopology()); 
    this.withStorageClassName(instance.getStorageClassName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private io.fabric8.kubernetes.api.model.Quantity capacity;
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.Quantity maximumVolumeSize;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private io.fabric8.kubernetes.api.model.LabelSelectorBuilder nodeTopology;
  private java.lang.String storageClassName;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.Quantity getCapacity() {
    return this.capacity;
  }
  public A withCapacity(io.fabric8.kubernetes.api.model.Quantity capacity) {
    this.capacity=capacity; return (A) this;
  }
  public java.lang.Boolean hasCapacity() {
    return this.capacity != null;
  }
  public A withNewCapacity(java.lang.String amount,java.lang.String format) {
    return (A)withCapacity(new Quantity(amount, format));
  }
  public A withNewCapacity(java.lang.String amount) {
    return (A)withCapacity(new Quantity(amount));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.Quantity getMaximumVolumeSize() {
    return this.maximumVolumeSize;
  }
  public A withMaximumVolumeSize(io.fabric8.kubernetes.api.model.Quantity maximumVolumeSize) {
    this.maximumVolumeSize=maximumVolumeSize; return (A) this;
  }
  public java.lang.Boolean hasMaximumVolumeSize() {
    return this.maximumVolumeSize != null;
  }
  public A withNewMaximumVolumeSize(java.lang.String amount,java.lang.String format) {
    return (A)withMaximumVolumeSize(new Quantity(amount, format));
  }
  public A withNewMaximumVolumeSize(java.lang.String amount) {
    return (A)withMaximumVolumeSize(new Quantity(amount));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodeTopology instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.LabelSelector getNodeTopology() {
    return this.nodeTopology!=null?this.nodeTopology.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildNodeTopology() {
    return this.nodeTopology!=null?this.nodeTopology.build():null;
  }
  public A withNodeTopology(io.fabric8.kubernetes.api.model.LabelSelector nodeTopology) {
    _visitables.get("nodeTopology").remove(this.nodeTopology);
    if (nodeTopology!=null){ this.nodeTopology= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(nodeTopology); _visitables.get("nodeTopology").add(this.nodeTopology);} return (A) this;
  }
  public java.lang.Boolean hasNodeTopology() {
    return this.nodeTopology != null;
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.NodeTopologyNested<A> withNewNodeTopology() {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluentImpl.NodeTopologyNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.NodeTopologyNested<A> withNewNodeTopologyLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluentImpl.NodeTopologyNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.NodeTopologyNested<A> editNodeTopology() {
    return withNewNodeTopologyLike(getNodeTopology());
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.NodeTopologyNested<A> editOrNewNodeTopology() {
    return withNewNodeTopologyLike(getNodeTopology() != null ? getNodeTopology(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.NodeTopologyNested<A> editOrNewNodeTopologyLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewNodeTopologyLike(getNodeTopology() != null ? getNodeTopology(): item);
  }
  public java.lang.String getStorageClassName() {
    return this.storageClassName;
  }
  public A withStorageClassName(java.lang.String storageClassName) {
    this.storageClassName=storageClassName; return (A) this;
  }
  public java.lang.Boolean hasStorageClassName() {
    return this.storageClassName != null;
  }
  
  /**
   * Method is deprecated. use withStorageClassName instead.
   */
  @java.lang.Deprecated
  public A withNewStorageClassName(java.lang.String arg0) {
    return (A)withStorageClassName(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CSIStorageCapacityFluentImpl that = (CSIStorageCapacityFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (maximumVolumeSize != null ? !maximumVolumeSize.equals(that.maximumVolumeSize) :that.maximumVolumeSize != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (nodeTopology != null ? !nodeTopology.equals(that.nodeTopology) :that.nodeTopology != null) return false;
    if (storageClassName != null ? !storageClassName.equals(that.storageClassName) :that.storageClassName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  capacity,  kind,  maximumVolumeSize,  metadata,  nodeTopology,  storageClassName,  additionalProperties,  super.hashCode());
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) CSIStorageCapacityFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class NodeTopologyNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.NodeTopologyNested<N>> implements io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityFluent.NodeTopologyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NodeTopologyNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    NodeTopologyNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) CSIStorageCapacityFluentImpl.this.withNodeTopology(builder.build());
    }
    public N endNodeTopology() {
      return and();
    }
    
  }
  
}