package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TokenRequestBuilder extends io.fabric8.kubernetes.api.model.storage.TokenRequestFluentImpl<io.fabric8.kubernetes.api.model.storage.TokenRequestBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.storage.TokenRequest,io.fabric8.kubernetes.api.model.storage.TokenRequestBuilder> {

    io.fabric8.kubernetes.api.model.storage.TokenRequestFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TokenRequestBuilder() {
        this(true);
    }

    public TokenRequestBuilder(java.lang.Boolean validationEnabled) {
        this(new TokenRequest(), validationEnabled);
    }

    public TokenRequestBuilder(io.fabric8.kubernetes.api.model.storage.TokenRequestFluent<?> fluent) {
        this(fluent, true);
    }

    public TokenRequestBuilder(io.fabric8.kubernetes.api.model.storage.TokenRequestFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TokenRequest(), validationEnabled);
    }

    public TokenRequestBuilder(io.fabric8.kubernetes.api.model.storage.TokenRequestFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.TokenRequest instance) {
        this(fluent, instance, true);
    }

    public TokenRequestBuilder(io.fabric8.kubernetes.api.model.storage.TokenRequestFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.TokenRequest instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAudience(instance.getAudience()); 
        fluent.withExpirationSeconds(instance.getExpirationSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public TokenRequestBuilder(io.fabric8.kubernetes.api.model.storage.TokenRequest instance) {
        this(instance,true);
    }

    public TokenRequestBuilder(io.fabric8.kubernetes.api.model.storage.TokenRequest instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAudience(instance.getAudience()); 
        this.withExpirationSeconds(instance.getExpirationSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.storage.TokenRequest build() {
        TokenRequest buildable = new TokenRequest(fluent.getAudience(),fluent.getExpirationSeconds());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TokenRequestBuilder that = (TokenRequestBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
