package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSIDriverSpecBuilder extends io.fabric8.kubernetes.api.model.storage.CSIDriverSpecFluentImpl<io.fabric8.kubernetes.api.model.storage.CSIDriverSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.storage.CSIDriverSpec,io.fabric8.kubernetes.api.model.storage.CSIDriverSpecBuilder> {

    io.fabric8.kubernetes.api.model.storage.CSIDriverSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CSIDriverSpecBuilder() {
        this(true);
    }

    public CSIDriverSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new CSIDriverSpec(), validationEnabled);
    }

    public CSIDriverSpecBuilder(io.fabric8.kubernetes.api.model.storage.CSIDriverSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public CSIDriverSpecBuilder(io.fabric8.kubernetes.api.model.storage.CSIDriverSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CSIDriverSpec(), validationEnabled);
    }

    public CSIDriverSpecBuilder(io.fabric8.kubernetes.api.model.storage.CSIDriverSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.CSIDriverSpec instance) {
        this(fluent, instance, true);
    }

    public CSIDriverSpecBuilder(io.fabric8.kubernetes.api.model.storage.CSIDriverSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.CSIDriverSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAttachRequired(instance.getAttachRequired()); 
        fluent.withFsGroupPolicy(instance.getFsGroupPolicy()); 
        fluent.withPodInfoOnMount(instance.getPodInfoOnMount()); 
        fluent.withRequiresRepublish(instance.getRequiresRepublish()); 
        fluent.withStorageCapacity(instance.getStorageCapacity()); 
        fluent.withTokenRequests(instance.getTokenRequests()); 
        fluent.withVolumeLifecycleModes(instance.getVolumeLifecycleModes()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIDriverSpecBuilder(io.fabric8.kubernetes.api.model.storage.CSIDriverSpec instance) {
        this(instance,true);
    }

    public CSIDriverSpecBuilder(io.fabric8.kubernetes.api.model.storage.CSIDriverSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAttachRequired(instance.getAttachRequired()); 
        this.withFsGroupPolicy(instance.getFsGroupPolicy()); 
        this.withPodInfoOnMount(instance.getPodInfoOnMount()); 
        this.withRequiresRepublish(instance.getRequiresRepublish()); 
        this.withStorageCapacity(instance.getStorageCapacity()); 
        this.withTokenRequests(instance.getTokenRequests()); 
        this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.storage.CSIDriverSpec build() {
        CSIDriverSpec buildable = new CSIDriverSpec(fluent.getAttachRequired(),fluent.getFsGroupPolicy(),fluent.getPodInfoOnMount(),fluent.getRequiresRepublish(),fluent.getStorageCapacity(),fluent.getTokenRequests(),fluent.getVolumeLifecycleModes());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSIDriverSpecBuilder that = (CSIDriverSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
