/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSource;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceBuilder;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSourceFluentImpl;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSpec;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class VolumeAttachmentSpecFluentImpl<A extends VolumeAttachmentSpecFluent<A>>
extends BaseFluent<A>
implements VolumeAttachmentSpecFluent<A> {
    private String attacher;
    private String nodeName;
    private VolumeAttachmentSourceBuilder source;
    private Map<String, Object> additionalProperties;

    public VolumeAttachmentSpecFluentImpl() {
    }

    public VolumeAttachmentSpecFluentImpl(VolumeAttachmentSpec instance) {
        this.withAttacher(instance.getAttacher());
        this.withNodeName(instance.getNodeName());
        this.withSource(instance.getSource());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getAttacher() {
        return this.attacher;
    }

    @Override
    public A withAttacher(String attacher) {
        this.attacher = attacher;
        return (A)this;
    }

    @Override
    public Boolean hasAttacher() {
        return this.attacher != null;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    @Deprecated
    public VolumeAttachmentSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public VolumeAttachmentSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(VolumeAttachmentSource source) {
        this._visitables.get((Object)"source").remove(this.source);
        if (source != null) {
            this.source = new VolumeAttachmentSourceBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public VolumeAttachmentSpecFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public VolumeAttachmentSpecFluent.SourceNested<A> withNewSourceLike(VolumeAttachmentSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public VolumeAttachmentSpecFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public VolumeAttachmentSpecFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new VolumeAttachmentSourceBuilder().build());
    }

    @Override
    public VolumeAttachmentSpecFluent.SourceNested<A> editOrNewSourceLike(VolumeAttachmentSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeAttachmentSpecFluentImpl that = (VolumeAttachmentSpecFluentImpl)o;
        if (this.attacher != null ? !this.attacher.equals(that.attacher) : that.attacher != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.attacher, this.nodeName, this.source, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attacher != null) {
            sb.append("attacher:");
            sb.append(this.attacher + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SourceNestedImpl<N>
    extends VolumeAttachmentSourceFluentImpl<VolumeAttachmentSpecFluent.SourceNested<N>>
    implements VolumeAttachmentSpecFluent.SourceNested<N>,
    Nested<N> {
        VolumeAttachmentSourceBuilder builder;

        SourceNestedImpl(VolumeAttachmentSource item) {
            this.builder = new VolumeAttachmentSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new VolumeAttachmentSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeAttachmentSpecFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

