package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CSINodeBuilder extends CSINodeFluent<CSINodeBuilder> implements VisitableBuilder<CSINode,CSINodeBuilder>{
  public CSINodeBuilder() {
    this(new CSINode());
  }
  
  public CSINodeBuilder(CSINodeFluent<?> fluent) {
    this(fluent, new CSINode());
  }
  
  public CSINodeBuilder(CSINodeFluent<?> fluent,CSINode instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CSINodeBuilder(CSINode instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CSINodeFluent<?> fluent;
  
  public CSINode build() {
    CSINode buildable = new CSINode(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}