package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VolumeErrorBuilder extends VolumeErrorFluent<VolumeErrorBuilder> implements VisitableBuilder<VolumeError,VolumeErrorBuilder>{
  public VolumeErrorBuilder() {
    this(new VolumeError());
  }
  
  public VolumeErrorBuilder(VolumeErrorFluent<?> fluent) {
    this(fluent, new VolumeError());
  }
  
  public VolumeErrorBuilder(VolumeErrorFluent<?> fluent,VolumeError instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VolumeErrorBuilder(VolumeError instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VolumeErrorFluent<?> fluent;
  
  public VolumeError build() {
    VolumeError buildable = new VolumeError(fluent.getMessage(),fluent.getTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}