package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeAttachmentListBuilder extends VolumeAttachmentListFluentImpl<VolumeAttachmentListBuilder> implements VisitableBuilder<VolumeAttachmentList,VolumeAttachmentListBuilder>{
  public VolumeAttachmentListBuilder() {
    this(false);
  }
  public VolumeAttachmentListBuilder(Boolean validationEnabled) {
    this(new VolumeAttachmentList(), validationEnabled);
  }
  public VolumeAttachmentListBuilder(VolumeAttachmentListFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeAttachmentListBuilder(VolumeAttachmentListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeAttachmentList(), validationEnabled);
  }
  public VolumeAttachmentListBuilder(VolumeAttachmentListFluent<?> fluent,VolumeAttachmentList instance) {
    this(fluent, instance, false);
  }
  public VolumeAttachmentListBuilder(VolumeAttachmentListFluent<?> fluent,VolumeAttachmentList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VolumeAttachmentListBuilder(VolumeAttachmentList instance) {
    this(instance,false);
  }
  public VolumeAttachmentListBuilder(VolumeAttachmentList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  VolumeAttachmentListFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeAttachmentList build() {
    VolumeAttachmentList buildable = new VolumeAttachmentList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}