package io.fabric8.kubernetes.api.model.storage;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VolumeAttachmentStatusFluentImpl<A extends VolumeAttachmentStatusFluent<A>> extends BaseFluent<A> implements VolumeAttachmentStatusFluent<A>{
  public VolumeAttachmentStatusFluentImpl() {
  }
  public VolumeAttachmentStatusFluentImpl(VolumeAttachmentStatus instance) {
    if (instance != null) {
      this.withAttachError(instance.getAttachError());
      this.withAttached(instance.getAttached());
      this.withAttachmentMetadata(instance.getAttachmentMetadata());
      this.withDetachError(instance.getDetachError());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private VolumeErrorBuilder attachError;
  private Boolean attached;
  private Map<String,String> attachmentMetadata;
  private VolumeErrorBuilder detachError;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAttachError instead.
   * @return The buildable object.
   */
  @Deprecated
  public VolumeError getAttachError() {
    return this.attachError!=null ?this.attachError.build():null;
  }
  public VolumeError buildAttachError() {
    return this.attachError!=null ?this.attachError.build():null;
  }
  public A withAttachError(VolumeError attachError) {
    _visitables.get("attachError").remove(this.attachError);
    if (attachError!=null){ this.attachError= new VolumeErrorBuilder(attachError); _visitables.get("attachError").add(this.attachError);} else { this.attachError = null; _visitables.get("attachError").remove(this.attachError); } return (A) this;
  }
  public Boolean hasAttachError() {
    return this.attachError != null;
  }
  public A withNewAttachError(String message,String time) {
    return (A)withAttachError(new VolumeError(message, time));
  }
  public VolumeAttachmentStatusFluentImpl.AttachErrorNested<A> withNewAttachError() {
    return new VolumeAttachmentStatusFluentImpl.AttachErrorNestedImpl();
  }
  public VolumeAttachmentStatusFluentImpl.AttachErrorNested<A> withNewAttachErrorLike(VolumeError item) {
    return new VolumeAttachmentStatusFluentImpl.AttachErrorNestedImpl(item);
  }
  public VolumeAttachmentStatusFluentImpl.AttachErrorNested<A> editAttachError() {
    return withNewAttachErrorLike(getAttachError());
  }
  public VolumeAttachmentStatusFluentImpl.AttachErrorNested<A> editOrNewAttachError() {
    return withNewAttachErrorLike(getAttachError() != null ? getAttachError(): new VolumeErrorBuilder().build());
  }
  public VolumeAttachmentStatusFluentImpl.AttachErrorNested<A> editOrNewAttachErrorLike(VolumeError item) {
    return withNewAttachErrorLike(getAttachError() != null ? getAttachError(): item);
  }
  public Boolean getAttached() {
    return this.attached;
  }
  public A withAttached(Boolean attached) {
    this.attached=attached; return (A) this;
  }
  public Boolean hasAttached() {
    return this.attached != null;
  }
  public A addToAttachmentMetadata(String key,String value) {
    if(this.attachmentMetadata == null && key != null && value != null) { this.attachmentMetadata = new LinkedHashMap(); }
    if(key != null && value != null) {this.attachmentMetadata.put(key, value);} return (A)this;
  }
  public A addToAttachmentMetadata(Map<String,String> map) {
    if(this.attachmentMetadata == null && map != null) { this.attachmentMetadata = new LinkedHashMap(); }
    if(map != null) { this.attachmentMetadata.putAll(map);} return (A)this;
  }
  public A removeFromAttachmentMetadata(String key) {
    if(this.attachmentMetadata == null) { return (A) this; }
    if(key != null && this.attachmentMetadata != null) {this.attachmentMetadata.remove(key);} return (A)this;
  }
  public A removeFromAttachmentMetadata(Map<String,String> map) {
    if(this.attachmentMetadata == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.attachmentMetadata != null){this.attachmentMetadata.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAttachmentMetadata() {
    return this.attachmentMetadata;
  }
  public <K,V>A withAttachmentMetadata(Map<String,String> attachmentMetadata) {
    if (attachmentMetadata == null) { this.attachmentMetadata =  null;} else {this.attachmentMetadata = new LinkedHashMap(attachmentMetadata);} return (A) this;
  }
  public Boolean hasAttachmentMetadata() {
    return this.attachmentMetadata != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDetachError instead.
   * @return The buildable object.
   */
  @Deprecated
  public VolumeError getDetachError() {
    return this.detachError!=null ?this.detachError.build():null;
  }
  public VolumeError buildDetachError() {
    return this.detachError!=null ?this.detachError.build():null;
  }
  public A withDetachError(VolumeError detachError) {
    _visitables.get("detachError").remove(this.detachError);
    if (detachError!=null){ this.detachError= new VolumeErrorBuilder(detachError); _visitables.get("detachError").add(this.detachError);} else { this.detachError = null; _visitables.get("detachError").remove(this.detachError); } return (A) this;
  }
  public Boolean hasDetachError() {
    return this.detachError != null;
  }
  public A withNewDetachError(String message,String time) {
    return (A)withDetachError(new VolumeError(message, time));
  }
  public VolumeAttachmentStatusFluentImpl.DetachErrorNested<A> withNewDetachError() {
    return new VolumeAttachmentStatusFluentImpl.DetachErrorNestedImpl();
  }
  public VolumeAttachmentStatusFluentImpl.DetachErrorNested<A> withNewDetachErrorLike(VolumeError item) {
    return new VolumeAttachmentStatusFluentImpl.DetachErrorNestedImpl(item);
  }
  public VolumeAttachmentStatusFluentImpl.DetachErrorNested<A> editDetachError() {
    return withNewDetachErrorLike(getDetachError());
  }
  public VolumeAttachmentStatusFluentImpl.DetachErrorNested<A> editOrNewDetachError() {
    return withNewDetachErrorLike(getDetachError() != null ? getDetachError(): new VolumeErrorBuilder().build());
  }
  public VolumeAttachmentStatusFluentImpl.DetachErrorNested<A> editOrNewDetachErrorLike(VolumeError item) {
    return withNewDetachErrorLike(getDetachError() != null ? getDetachError(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VolumeAttachmentStatusFluentImpl that = (VolumeAttachmentStatusFluentImpl) o;
    if (!java.util.Objects.equals(attachError, that.attachError)) return false;

    if (!java.util.Objects.equals(attached, that.attached)) return false;

    if (!java.util.Objects.equals(attachmentMetadata, that.attachmentMetadata)) return false;

    if (!java.util.Objects.equals(detachError, that.detachError)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(attachError,  attached,  attachmentMetadata,  detachError,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attachError != null) { sb.append("attachError:"); sb.append(attachError + ","); }
    if (attached != null) { sb.append("attached:"); sb.append(attached + ","); }
    if (attachmentMetadata != null && !attachmentMetadata.isEmpty()) { sb.append("attachmentMetadata:"); sb.append(attachmentMetadata + ","); }
    if (detachError != null) { sb.append("detachError:"); sb.append(detachError + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAttached() {
    return withAttached(true);
  }
  class AttachErrorNestedImpl<N> extends VolumeErrorFluentImpl<VolumeAttachmentStatusFluentImpl.AttachErrorNested<N>> implements VolumeAttachmentStatusFluentImpl.AttachErrorNested<N>,Nested<N>{
    AttachErrorNestedImpl(VolumeError item) {
      this.builder = new VolumeErrorBuilder(this, item);
    }
    AttachErrorNestedImpl() {
      this.builder = new VolumeErrorBuilder(this);
    }
    VolumeErrorBuilder builder;
    public N and() {
      return (N) VolumeAttachmentStatusFluentImpl.this.withAttachError(builder.build());
    }
    public N endAttachError() {
      return and();
    }
    
  }
  class DetachErrorNestedImpl<N> extends VolumeErrorFluentImpl<VolumeAttachmentStatusFluentImpl.DetachErrorNested<N>> implements VolumeAttachmentStatusFluentImpl.DetachErrorNested<N>,Nested<N>{
    DetachErrorNestedImpl(VolumeError item) {
      this.builder = new VolumeErrorBuilder(this, item);
    }
    DetachErrorNestedImpl() {
      this.builder = new VolumeErrorBuilder(this);
    }
    VolumeErrorBuilder builder;
    public N and() {
      return (N) VolumeAttachmentStatusFluentImpl.this.withDetachError(builder.build());
    }
    public N endDetachError() {
      return and();
    }
    
  }
  
}