package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface CSIStorageCapacityFluent<A extends CSIStorageCapacityFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public Quantity getCapacity();
  public A withCapacity(Quantity capacity);
  public Boolean hasCapacity();
  public A withNewCapacity(String amount,String format);
  public A withNewCapacity(String amount);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public Quantity getMaximumVolumeSize();
  public A withMaximumVolumeSize(Quantity maximumVolumeSize);
  public Boolean hasMaximumVolumeSize();
  public A withNewMaximumVolumeSize(String amount,String format);
  public A withNewMaximumVolumeSize(String amount);
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public CSIStorageCapacityFluent.MetadataNested<A> withNewMetadata();
  public CSIStorageCapacityFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public CSIStorageCapacityFluent.MetadataNested<A> editMetadata();
  public CSIStorageCapacityFluent.MetadataNested<A> editOrNewMetadata();
  public CSIStorageCapacityFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildNodeTopology instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNodeTopology();
  public LabelSelector buildNodeTopology();
  public A withNodeTopology(LabelSelector nodeTopology);
  public Boolean hasNodeTopology();
  public CSIStorageCapacityFluent.NodeTopologyNested<A> withNewNodeTopology();
  public CSIStorageCapacityFluent.NodeTopologyNested<A> withNewNodeTopologyLike(LabelSelector item);
  public CSIStorageCapacityFluent.NodeTopologyNested<A> editNodeTopology();
  public CSIStorageCapacityFluent.NodeTopologyNested<A> editOrNewNodeTopology();
  public CSIStorageCapacityFluent.NodeTopologyNested<A> editOrNewNodeTopologyLike(LabelSelector item);
  public String getStorageClassName();
  public A withStorageClassName(String storageClassName);
  public Boolean hasStorageClassName();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<CSIStorageCapacityFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface NodeTopologyNested<N> extends Nested<N>,LabelSelectorFluent<CSIStorageCapacityFluent.NodeTopologyNested<N>>{
    public N and();
    public N endNodeTopology();
    
  }
  
}