package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeAttachmentStatusBuilder extends VolumeAttachmentStatusFluent<VolumeAttachmentStatusBuilder> implements VisitableBuilder<VolumeAttachmentStatus,VolumeAttachmentStatusBuilder>{
  public VolumeAttachmentStatusBuilder() {
    this(false);
  }
  public VolumeAttachmentStatusBuilder(Boolean validationEnabled) {
    this(new VolumeAttachmentStatus(), validationEnabled);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeAttachmentStatus(), validationEnabled);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent,VolumeAttachmentStatus instance) {
    this(fluent, instance, false);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent,VolumeAttachmentStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VolumeAttachmentStatus());

    if (instance != null) {
      fluent.withAttachError(instance.getAttachError());
      fluent.withAttached(instance.getAttached());
      fluent.withAttachmentMetadata(instance.getAttachmentMetadata());
      fluent.withDetachError(instance.getDetachError());
      fluent.withAttachError(instance.getAttachError());
      fluent.withAttached(instance.getAttached());
      fluent.withAttachmentMetadata(instance.getAttachmentMetadata());
      fluent.withDetachError(instance.getDetachError());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatus instance) {
    this(instance,false);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VolumeAttachmentStatus());

    if (instance != null) {
      this.withAttachError(instance.getAttachError());
      this.withAttached(instance.getAttached());
      this.withAttachmentMetadata(instance.getAttachmentMetadata());
      this.withDetachError(instance.getDetachError());
      this.withAttachError(instance.getAttachError());
      this.withAttached(instance.getAttached());
      this.withAttachmentMetadata(instance.getAttachmentMetadata());
      this.withDetachError(instance.getDetachError());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumeAttachmentStatusFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeAttachmentStatus build() {
    VolumeAttachmentStatus buildable = new VolumeAttachmentStatus(fluent.buildAttachError(),fluent.getAttached(),fluent.getAttachmentMetadata(),fluent.buildDetachError());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}