/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.validator;

import com.atlassian.oai.validator.report.ValidationReport;
import io.fabric8.kubernetes.schema.validator.ValidationMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;

public class ValidationReport {
    static final ValidationReport EMPTY = new ValidationReport(Collections.emptyList());
    static final ValidationReport MISSING_KIND = new ValidationReport(Collections.singletonList(new ValidationMessage(ValidationMessage.Level.ERROR, null, "[Path '/'] Object has missing required properties ([\"kind\"])")));
    static final ValidationReport MISSING_API_VERSION = new ValidationReport(Collections.singletonList(new ValidationMessage(ValidationMessage.Level.ERROR, null, "[Path '/'] Object has missing or invalid required properties ([\"apiVersion\"])")));
    private final Collection<ValidationMessage> messages;
    private final boolean hasErrors;

    public ValidationReport(Collection<ValidationMessage> messages) {
        this.messages = Collections.unmodifiableCollection(messages);
        this.hasErrors = messages.stream().anyMatch(m -> m.getLevel() == ValidationMessage.Level.ERROR);
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    static ValidationReport from(Collection<ValidationReport.Message> messages) {
        return new ValidationReport(messages.stream().map(ValidationMessage::from).collect(Collectors.toList()));
    }

    @Generated
    public Collection<ValidationMessage> getMessages() {
        return this.messages;
    }
}

