package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ContainerStateFluent<T extends ContainerStateFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<ContainerStateRunning, ?> running;     VisitableBuilder<ContainerStateTerminated, ?> termination;     VisitableBuilder<ContainerStateWaiting, ?> waiting;     Map<String, Object> additionalProperties = new HashMap();

    public ContainerStateRunning getRunning(){
    return this.running!=null?this.running.build():null;
    }
    public T withRunning( ContainerStateRunning running){
    if (running!=null){ this.running= new ContainerStateRunningBuilder(running); _visitables.add(this.running);} return (T) this;
    }
    public RunningNested<T> withNewRunning(){
    return new RunningNested<T>();
    }
    public RunningNested<T> withNewRunningLike( ContainerStateRunning item){
    return new RunningNested<T>(item);
    }
    public RunningNested<T> editRunning(){
    return withNewRunningLike(getRunning());
    }
    public T withNewRunning( String startedAt){
    return withRunning(new ContainerStateRunning(startedAt));
    }
    public ContainerStateTerminated getTermination(){
    return this.termination!=null?this.termination.build():null;
    }
    public T withTermination( ContainerStateTerminated termination){
    if (termination!=null){ this.termination= new ContainerStateTerminatedBuilder(termination); _visitables.add(this.termination);} return (T) this;
    }
    public TerminationNested<T> withNewTermination(){
    return new TerminationNested<T>();
    }
    public TerminationNested<T> withNewTerminationLike( ContainerStateTerminated item){
    return new TerminationNested<T>(item);
    }
    public TerminationNested<T> editTermination(){
    return withNewTerminationLike(getTermination());
    }
    public ContainerStateWaiting getWaiting(){
    return this.waiting!=null?this.waiting.build():null;
    }
    public T withWaiting( ContainerStateWaiting waiting){
    if (waiting!=null){ this.waiting= new ContainerStateWaitingBuilder(waiting); _visitables.add(this.waiting);} return (T) this;
    }
    public WaitingNested<T> withNewWaiting(){
    return new WaitingNested<T>();
    }
    public WaitingNested<T> withNewWaitingLike( ContainerStateWaiting item){
    return new WaitingNested<T>(item);
    }
    public WaitingNested<T> editWaiting(){
    return withNewWaitingLike(getWaiting());
    }
    public T withNewWaiting( String reason){
    return withWaiting(new ContainerStateWaiting(reason));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class RunningNested<N> extends ContainerStateRunningFluent<RunningNested<N>> implements Nested<N>{

        private final ContainerStateRunningBuilder builder;
    
             RunningNested ( ContainerStateRunning item){
        this.builder = new ContainerStateRunningBuilder(this, item);
        }
             RunningNested (){
        this.builder = new ContainerStateRunningBuilder(this);
        }
    
            public N and(){
            return (N) ContainerStateFluent.this.withRunning(builder.build());
        }
            public N endRunning(){
            return and();
        }
    
}
    public class TerminationNested<N> extends ContainerStateTerminatedFluent<TerminationNested<N>> implements Nested<N>{

        private final ContainerStateTerminatedBuilder builder;
    
             TerminationNested (){
        this.builder = new ContainerStateTerminatedBuilder(this);
        }
             TerminationNested ( ContainerStateTerminated item){
        this.builder = new ContainerStateTerminatedBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerStateFluent.this.withTermination(builder.build());
        }
            public N endTermination(){
            return and();
        }
    
}
    public class WaitingNested<N> extends ContainerStateWaitingFluent<WaitingNested<N>> implements Nested<N>{

        private final ContainerStateWaitingBuilder builder;
    
             WaitingNested (){
        this.builder = new ContainerStateWaitingBuilder(this);
        }
             WaitingNested ( ContainerStateWaiting item){
        this.builder = new ContainerStateWaitingBuilder(this, item);
        }
    
            public N endWaiting(){
            return and();
        }
            public N and(){
            return (N) ContainerStateFluent.this.withWaiting(builder.build());
        }
    
}


}
