package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class SecretFluent<T extends SecretFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Secret.ApiVersion apiVersion;     Map<String, String> data = new HashMap();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public Secret.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Secret.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToData( String key,  String value){
    if(key != null && value != null) {this.data.put(key, value);} return (T)this;
    }
    public Map<String, String> getData(){
    return this.data;
    }
    public T withData( Map<String, String> data){
    this.data.clear();if (data != null) {this.data.putAll(data);} return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) SecretFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
