package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class BuildConfigStatusBuilder extends BuildConfigStatusFluent<BuildConfigStatusBuilder> implements VisitableBuilder<BuildConfigStatus,BuildConfigStatusBuilder>{

     BuildConfigStatusFluent<?> fluent;
public BuildConfigStatusBuilder(){
    this(new BuildConfigStatus());
}
public BuildConfigStatusBuilder( BuildConfigStatusFluent<?> fluent ){
    this(fluent, new BuildConfigStatus());
}
public BuildConfigStatusBuilder( BuildConfigStatusFluent<?> fluent , BuildConfigStatus instance ){
    this.fluent = fluent; fluent.withLastVersion(instance.getLastVersion()); 
}
public BuildConfigStatusBuilder( BuildConfigStatus instance ){
    this.fluent = this; this.withLastVersion(instance.getLastVersion()); 
}

public EditableBuildConfigStatus build(){
    EditableBuildConfigStatus buildable = new EditableBuildConfigStatus(fluent.getLastVersion());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    