
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "endpoints",
    "path",
    "readOnly"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class GlusterfsVolumeSource {

    /**
     * gluster hosts endpoints name
     * 
     */
    @JsonProperty("endpoints")
    private String endpoints;
    /**
     * path to gluster volume
     * 
     */
    @JsonProperty("path")
    private String path;
    /**
     * glusterfs volume to be mounted with read-only permissions
     * 
     */
    @JsonProperty("readOnly")
    private Boolean readOnly;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public GlusterfsVolumeSource() {
    }

    /**
     * 
     * @param readOnly
     * @param endpoints
     * @param path
     */
    public GlusterfsVolumeSource(String endpoints, String path, Boolean readOnly) {
        this.endpoints = endpoints;
        this.path = path;
        this.readOnly = readOnly;
    }

    /**
     * gluster hosts endpoints name
     * 
     * @return
     *     The endpoints
     */
    @JsonProperty("endpoints")
    public String getEndpoints() {
        return endpoints;
    }

    /**
     * gluster hosts endpoints name
     * 
     * @param endpoints
     *     The endpoints
     */
    @JsonProperty("endpoints")
    public void setEndpoints(String endpoints) {
        this.endpoints = endpoints;
    }

    /**
     * path to gluster volume
     * 
     * @return
     *     The path
     */
    @JsonProperty("path")
    public String getPath() {
        return path;
    }

    /**
     * path to gluster volume
     * 
     * @param path
     *     The path
     */
    @JsonProperty("path")
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * glusterfs volume to be mounted with read-only permissions
     * 
     * @return
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public Boolean getReadOnly() {
        return readOnly;
    }

    /**
     * glusterfs volume to be mounted with read-only permissions
     * 
     * @param readOnly
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(endpoints).append(path).append(readOnly).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GlusterfsVolumeSource) == false) {
            return false;
        }
        GlusterfsVolumeSource rhs = ((GlusterfsVolumeSource) other);
        return new EqualsBuilder().append(endpoints, rhs.endpoints).append(path, rhs.path).append(readOnly, rhs.readOnly).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
