package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class NamespaceFluent<T extends NamespaceFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Namespace.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<NamespaceSpec, ?> spec;     VisitableBuilder<NamespaceStatus, ?> status;     Map<String, Object> additionalProperties = new HashMap();

    public Namespace.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Namespace.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public NamespaceSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( NamespaceSpec spec){
    if (spec!=null){ this.spec= new NamespaceSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNested<T>();
    }
    public SpecNested<T> withNewSpecLike( NamespaceSpec item){
    return new SpecNested<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public NamespaceStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public T withStatus( NamespaceStatus status){
    if (status!=null){ this.status= new NamespaceStatusBuilder(status); _visitables.add(this.status);} return (T) this;
    }
    public StatusNested<T> withNewStatus(){
    return new StatusNested<T>();
    }
    public StatusNested<T> withNewStatusLike( NamespaceStatus item){
    return new StatusNested<T>(item);
    }
    public StatusNested<T> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public T withNewStatus( String phase){
    return withStatus(new NamespaceStatus(phase));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) NamespaceFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNested<N> extends NamespaceSpecFluent<SpecNested<N>> implements Nested<N>{

        private final NamespaceSpecBuilder builder;
    
             SpecNested (){
        this.builder = new NamespaceSpecBuilder(this);
        }
             SpecNested ( NamespaceSpec item){
        this.builder = new NamespaceSpecBuilder(this, item);
        }
    
            public N and(){
            return (N) NamespaceFluent.this.withSpec(builder.build());
        }
            public N endSpec(){
            return and();
        }
    
}
    public class StatusNested<N> extends NamespaceStatusFluent<StatusNested<N>> implements Nested<N>{

        private final NamespaceStatusBuilder builder;
    
             StatusNested (){
        this.builder = new NamespaceStatusBuilder(this);
        }
             StatusNested ( NamespaceStatus item){
        this.builder = new NamespaceStatusBuilder(this, item);
        }
    
            public N and(){
            return (N) NamespaceFluent.this.withStatus(builder.build());
        }
            public N endStatus(){
            return and();
        }
    
}


}
