package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ImageChangeTriggerBuilder extends ImageChangeTriggerFluent<ImageChangeTriggerBuilder> implements VisitableBuilder<ImageChangeTrigger,ImageChangeTriggerBuilder>{

     ImageChangeTriggerFluent<?> fluent;
public ImageChangeTriggerBuilder(){
    this(new ImageChangeTrigger());
}
public ImageChangeTriggerBuilder( ImageChangeTriggerFluent<?> fluent ){
    this(fluent, new ImageChangeTrigger());
}
public ImageChangeTriggerBuilder( ImageChangeTriggerFluent<?> fluent , ImageChangeTrigger instance ){
    this.fluent = fluent; fluent.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
}
public ImageChangeTriggerBuilder( ImageChangeTrigger instance ){
    this.fluent = this; this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
}

public EditableImageChangeTrigger build(){
    EditableImageChangeTrigger buildable = new EditableImageChangeTrigger(fluent.getLastTriggeredImageID());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    