package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class PersistentVolumeClaimFluent<T extends PersistentVolumeClaimFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     PersistentVolumeClaim.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<PersistentVolumeClaimSpec, ?> spec;     PersistentVolumeClaimStatus status;     Map<String, Object> additionalProperties = new HashMap();

    public PersistentVolumeClaim.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( PersistentVolumeClaim.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public PersistentVolumeClaimSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( PersistentVolumeClaimSpec spec){
    if (spec!=null){ this.spec= new PersistentVolumeClaimSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNested<T>();
    }
    public SpecNested<T> withNewSpecLike( PersistentVolumeClaimSpec item){
    return new SpecNested<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public PersistentVolumeClaimStatus getStatus(){
    return this.status;
    }
    public T withStatus( PersistentVolumeClaimStatus status){
    this.status=status; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeClaimFluent.this.withMetadata(builder.build());
        }
    
}
    public class SpecNested<N> extends PersistentVolumeClaimSpecFluent<SpecNested<N>> implements Nested<N>{

        private final PersistentVolumeClaimSpecBuilder builder;
    
             SpecNested (){
        this.builder = new PersistentVolumeClaimSpecBuilder(this);
        }
             SpecNested ( PersistentVolumeClaimSpec item){
        this.builder = new PersistentVolumeClaimSpecBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeClaimFluent.this.withSpec(builder.build());
        }
            public N endSpec(){
            return and();
        }
    
}


}
