package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ServiceAccountListFluent<T extends ServiceAccountListFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     ServiceAccountList.ApiVersion apiVersion;     List<VisitableBuilder<ServiceAccount, ?>> items = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public ServiceAccountList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ServiceAccountList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( ServiceAccount item){
    if (item != null) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public List<ServiceAccount> getItems(){
    return build(items);
    }
    public T withItems( List<ServiceAccount> items){
    this.items.clear();if (items != null) {for (ServiceAccount item : items){this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNested<T>();
    }
    public ItemsNested<T> addNewItemLike( ServiceAccount item){
    return new ItemsNested<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class ItemsNested<N> extends ServiceAccountFluent<ItemsNested<N>> implements Nested<N>{

        private final ServiceAccountBuilder builder;
    
             ItemsNested ( ServiceAccount item){
        this.builder = new ServiceAccountBuilder(this, item);
        }
             ItemsNested (){
        this.builder = new ServiceAccountBuilder(this);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) ServiceAccountListFluent.this.addToItems(builder.build());
        }
    
}
    public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNested ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ListMetaBuilder(this);
        }
    
            public N and(){
            return (N) ServiceAccountListFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
