package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class CustomBuildStrategyFluent<T extends CustomBuildStrategyFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();     Boolean exposeDockerSocket;     VisitableBuilder<ObjectReference, ?> from;     LocalObjectReference pullSecret;     Map<String, Object> additionalProperties = new HashMap();

    public T addToEnv( EnvVar item){
    if (item != null) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (T)this;
    }
    public List<EnvVar> getEnv(){
    return build(env);
    }
    public T withEnv( List<EnvVar> env){
    this.env.clear();if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (T) this;
    }
    public EnvNested<T> addNewEnv(){
    return new EnvNested<T>();
    }
    public EnvNested<T> addNewEnvLike( EnvVar item){
    return new EnvNested<T>(item);
    }
    public Boolean isExposeDockerSocket(){
    return this.exposeDockerSocket;
    }
    public T withExposeDockerSocket( Boolean exposeDockerSocket){
    this.exposeDockerSocket=exposeDockerSocket; return (T) this;
    }
    public ObjectReference getFrom(){
    return this.from!=null?this.from.build():null;
    }
    public T withFrom( ObjectReference from){
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (T) this;
    }
    public FromNested<T> withNewFrom(){
    return new FromNested<T>();
    }
    public FromNested<T> withNewFromLike( ObjectReference item){
    return new FromNested<T>(item);
    }
    public FromNested<T> editFrom(){
    return withNewFromLike(getFrom());
    }
    public LocalObjectReference getPullSecret(){
    return this.pullSecret;
    }
    public T withPullSecret( LocalObjectReference pullSecret){
    this.pullSecret=pullSecret; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class EnvNested<N> extends EnvVarFluent<EnvNested<N>> implements Nested<N>{

        private final EnvVarBuilder builder;
    
             EnvNested ( EnvVar item){
        this.builder = new EnvVarBuilder(this, item);
        }
             EnvNested (){
        this.builder = new EnvVarBuilder(this);
        }
    
            public N and(){
            return (N) CustomBuildStrategyFluent.this.addToEnv(builder.build());
        }
            public N endEnv(){
            return and();
        }
    
}
    public class FromNested<N> extends ObjectReferenceFluent<FromNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             FromNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
             FromNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
    
            public N endFrom(){
            return and();
        }
            public N and(){
            return (N) CustomBuildStrategyFluent.this.withFrom(builder.build());
        }
    
}


}
