
package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "output",
    "resources",
    "revision",
    "serviceAccount",
    "source",
    "strategy",
    "triggers"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class BuildConfigSpec {

    /**
     * 
     * 
     */
    @JsonProperty("output")
    @Valid
    private BuildOutput output;
    /**
     * 
     * 
     */
    @JsonProperty("resources")
    @Valid
    private ResourceRequirements resources;
    /**
     * 
     * 
     */
    @JsonProperty("revision")
    @Valid
    private SourceRevision revision;
    /**
     * the name of the service account to use to run pods created by the build
     * 
     */
    @JsonProperty("serviceAccount")
    private String serviceAccount;
    /**
     * 
     * 
     */
    @JsonProperty("source")
    @Valid
    private BuildSource source;
    /**
     * 
     * 
     */
    @JsonProperty("strategy")
    @Valid
    private BuildStrategy strategy;
    /**
     * determines how new builds can be launched from a build config.  if no triggers are defined
     * 
     */
    @JsonProperty("triggers")
    @Valid
    private List<BuildTriggerPolicy> triggers = new ArrayList<BuildTriggerPolicy>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BuildConfigSpec() {
    }

    /**
     * 
     * @param revision
     * @param resources
     * @param source
     * @param serviceAccount
     * @param strategy
     * @param triggers
     * @param output
     */
    public BuildConfigSpec(BuildOutput output, ResourceRequirements resources, SourceRevision revision, String serviceAccount, BuildSource source, BuildStrategy strategy, List<BuildTriggerPolicy> triggers) {
        this.output = output;
        this.resources = resources;
        this.revision = revision;
        this.serviceAccount = serviceAccount;
        this.source = source;
        this.strategy = strategy;
        this.triggers = triggers;
    }

    /**
     * 
     * 
     * @return
     *     The output
     */
    @JsonProperty("output")
    public BuildOutput getOutput() {
        return output;
    }

    /**
     * 
     * 
     * @param output
     *     The output
     */
    @JsonProperty("output")
    public void setOutput(BuildOutput output) {
        this.output = output;
    }

    /**
     * 
     * 
     * @return
     *     The resources
     */
    @JsonProperty("resources")
    public ResourceRequirements getResources() {
        return resources;
    }

    /**
     * 
     * 
     * @param resources
     *     The resources
     */
    @JsonProperty("resources")
    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    /**
     * 
     * 
     * @return
     *     The revision
     */
    @JsonProperty("revision")
    public SourceRevision getRevision() {
        return revision;
    }

    /**
     * 
     * 
     * @param revision
     *     The revision
     */
    @JsonProperty("revision")
    public void setRevision(SourceRevision revision) {
        this.revision = revision;
    }

    /**
     * the name of the service account to use to run pods created by the build
     * 
     * @return
     *     The serviceAccount
     */
    @JsonProperty("serviceAccount")
    public String getServiceAccount() {
        return serviceAccount;
    }

    /**
     * the name of the service account to use to run pods created by the build
     * 
     * @param serviceAccount
     *     The serviceAccount
     */
    @JsonProperty("serviceAccount")
    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    /**
     * 
     * 
     * @return
     *     The source
     */
    @JsonProperty("source")
    public BuildSource getSource() {
        return source;
    }

    /**
     * 
     * 
     * @param source
     *     The source
     */
    @JsonProperty("source")
    public void setSource(BuildSource source) {
        this.source = source;
    }

    /**
     * 
     * 
     * @return
     *     The strategy
     */
    @JsonProperty("strategy")
    public BuildStrategy getStrategy() {
        return strategy;
    }

    /**
     * 
     * 
     * @param strategy
     *     The strategy
     */
    @JsonProperty("strategy")
    public void setStrategy(BuildStrategy strategy) {
        this.strategy = strategy;
    }

    /**
     * determines how new builds can be launched from a build config.  if no triggers are defined
     * 
     * @return
     *     The triggers
     */
    @JsonProperty("triggers")
    public List<BuildTriggerPolicy> getTriggers() {
        return triggers;
    }

    /**
     * determines how new builds can be launched from a build config.  if no triggers are defined
     * 
     * @param triggers
     *     The triggers
     */
    @JsonProperty("triggers")
    public void setTriggers(List<BuildTriggerPolicy> triggers) {
        this.triggers = triggers;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(output).append(resources).append(revision).append(serviceAccount).append(source).append(strategy).append(triggers).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof BuildConfigSpec) == false) {
            return false;
        }
        BuildConfigSpec rhs = ((BuildConfigSpec) other);
        return new EqualsBuilder().append(output, rhs.output).append(resources, rhs.resources).append(revision, rhs.revision).append(serviceAccount, rhs.serviceAccount).append(source, rhs.source).append(strategy, rhs.strategy).append(triggers, rhs.triggers).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
