package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ServiceAccountFluent<T extends ServiceAccountFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     ServiceAccount.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<ObjectReference, ?>> secrets = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public ServiceAccount.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ServiceAccount.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToSecrets( ObjectReference item){
    if (item != null) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.add(builder);this.secrets.add(builder);} return (T)this;
    }
    public List<ObjectReference> getSecrets(){
    return build(secrets);
    }
    public T withSecrets( List<ObjectReference> secrets){
    this.secrets.clear();if (secrets != null) {for (ObjectReference item : secrets){this.addToSecrets(item);}} return (T) this;
    }
    public SecretsNested<T> addNewSecret(){
    return new SecretsNested<T>();
    }
    public SecretsNested<T> addNewSecretLike( ObjectReference item){
    return new SecretsNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) ServiceAccountFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SecretsNested<N> extends ObjectReferenceFluent<SecretsNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             SecretsNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
             SecretsNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
    
            public N endSecret(){
            return and();
        }
            public N and(){
            return (N) ServiceAccountFluent.this.addToSecrets(builder.build());
        }
    
}


}
