package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DeploymentTriggerImageChangeParamsBuilder extends DeploymentTriggerImageChangeParamsFluent<DeploymentTriggerImageChangeParamsBuilder> implements VisitableBuilder<DeploymentTriggerImageChangeParams,DeploymentTriggerImageChangeParamsBuilder>{

     DeploymentTriggerImageChangeParamsFluent<?> fluent;
public DeploymentTriggerImageChangeParamsBuilder(){
    this(new DeploymentTriggerImageChangeParams());
}
public DeploymentTriggerImageChangeParamsBuilder( DeploymentTriggerImageChangeParamsFluent<?> fluent ){
    this(fluent, new DeploymentTriggerImageChangeParams());
}
public DeploymentTriggerImageChangeParamsBuilder( DeploymentTriggerImageChangeParamsFluent<?> fluent , DeploymentTriggerImageChangeParams instance ){
    this.fluent = fluent; fluent.withAutomatic(instance.getAutomatic()); fluent.withContainerNames(instance.getContainerNames()); fluent.withFrom(instance.getFrom()); fluent.withLastTriggeredImage(instance.getLastTriggeredImage()); 
}
public DeploymentTriggerImageChangeParamsBuilder( DeploymentTriggerImageChangeParams instance ){
    this.fluent = this; this.withAutomatic(instance.getAutomatic()); this.withContainerNames(instance.getContainerNames()); this.withFrom(instance.getFrom()); this.withLastTriggeredImage(instance.getLastTriggeredImage()); 
}

public EditableDeploymentTriggerImageChangeParams build(){
    EditableDeploymentTriggerImageChangeParams buildable = new EditableDeploymentTriggerImageChangeParams(fluent.isAutomatic(),fluent.getContainerNames(),fluent.getFrom(),fluent.getLastTriggeredImage());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    