
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "fsType",
    "partition",
    "pdName",
    "readOnly"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class GCEPersistentDiskVolumeSource {

    /**
     * file system type to mount
     * 
     */
    @JsonProperty("fsType")
    private String fsType;
    /**
     * partition on the disk to mount (e.g.
     * 
     */
    @JsonProperty("partition")
    private Integer partition;
    /**
     * unique name of the PD resource in GCE
     * 
     */
    @JsonProperty("pdName")
    private String pdName;
    /**
     * read-only if true
     * 
     */
    @JsonProperty("readOnly")
    private Boolean readOnly;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public GCEPersistentDiskVolumeSource() {
    }

    /**
     * 
     * @param pdName
     * @param fsType
     * @param readOnly
     * @param partition
     */
    public GCEPersistentDiskVolumeSource(String fsType, Integer partition, String pdName, Boolean readOnly) {
        this.fsType = fsType;
        this.partition = partition;
        this.pdName = pdName;
        this.readOnly = readOnly;
    }

    /**
     * file system type to mount
     * 
     * @return
     *     The fsType
     */
    @JsonProperty("fsType")
    public String getFsType() {
        return fsType;
    }

    /**
     * file system type to mount
     * 
     * @param fsType
     *     The fsType
     */
    @JsonProperty("fsType")
    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    /**
     * partition on the disk to mount (e.g.
     * 
     * @return
     *     The partition
     */
    @JsonProperty("partition")
    public Integer getPartition() {
        return partition;
    }

    /**
     * partition on the disk to mount (e.g.
     * 
     * @param partition
     *     The partition
     */
    @JsonProperty("partition")
    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    /**
     * unique name of the PD resource in GCE
     * 
     * @return
     *     The pdName
     */
    @JsonProperty("pdName")
    public String getPdName() {
        return pdName;
    }

    /**
     * unique name of the PD resource in GCE
     * 
     * @param pdName
     *     The pdName
     */
    @JsonProperty("pdName")
    public void setPdName(String pdName) {
        this.pdName = pdName;
    }

    /**
     * read-only if true
     * 
     * @return
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public Boolean getReadOnly() {
        return readOnly;
    }

    /**
     * read-only if true
     * 
     * @param readOnly
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(fsType).append(partition).append(pdName).append(readOnly).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GCEPersistentDiskVolumeSource) == false) {
            return false;
        }
        GCEPersistentDiskVolumeSource rhs = ((GCEPersistentDiskVolumeSource) other);
        return new EqualsBuilder().append(fsType, rhs.fsType).append(partition, rhs.partition).append(pdName, rhs.pdName).append(readOnly, rhs.readOnly).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
