package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class HTTPGetActionFluent<T extends HTTPGetActionFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String host;     String path;     VisitableBuilder<IntOrString, ?> port;     Map<String, Object> additionalProperties = new HashMap();

    public String getHost(){
    return this.host;
    }
    public T withHost( String host){
    this.host=host; return (T) this;
    }
    public String getPath(){
    return this.path;
    }
    public T withPath( String path){
    this.path=path; return (T) this;
    }
    public IntOrString getPort(){
    return this.port!=null?this.port.build():null;
    }
    public T withPort( IntOrString port){
    if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.add(this.port);} return (T) this;
    }
    public PortNested<T> withNewPort(){
    return new PortNested<T>();
    }
    public PortNested<T> withNewPortLike( IntOrString item){
    return new PortNested<T>(item);
    }
    public PortNested<T> editPort(){
    return withNewPortLike(getPort());
    }
    public T withNewPort( Integer intVal){
    return withPort(new IntOrString(intVal));
    }
    public T withNewPort( String strVal){
    return withPort(new IntOrString(strVal));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class PortNested<N> extends IntOrStringFluent<PortNested<N>> implements Nested<N>{

        private final IntOrStringBuilder builder;
    
             PortNested (){
        this.builder = new IntOrStringBuilder(this);
        }
             PortNested ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N and(){
            return (N) HTTPGetActionFluent.this.withPort(builder.build());
        }
            public N endPort(){
            return and();
        }
    
}


}
