package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class DeploymentConfigSpecFluent<T extends DeploymentConfigSpecFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Integer replicas;     Map<String, String> selector = new HashMap();     VisitableBuilder<DeploymentStrategy, ?> strategy;     VisitableBuilder<PodTemplateSpec, ?> template;     VisitableBuilder<ObjectReference, ?> templateRef;     List<VisitableBuilder<DeploymentTriggerPolicy, ?>> triggers = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public Integer getReplicas(){
    return this.replicas;
    }
    public T withReplicas( Integer replicas){
    this.replicas=replicas; return (T) this;
    }
    public T addToSelector( String key,  String value){
    if(key != null && value != null) {this.selector.put(key, value);} return (T)this;
    }
    public Map<String, String> getSelector(){
    return this.selector;
    }
    public T withSelector( Map<String, String> selector){
    this.selector.clear();if (selector != null) {this.selector.putAll(selector);} return (T) this;
    }
    public DeploymentStrategy getStrategy(){
    return this.strategy!=null?this.strategy.build():null;
    }
    public T withStrategy( DeploymentStrategy strategy){
    if (strategy!=null){ this.strategy= new DeploymentStrategyBuilder(strategy); _visitables.add(this.strategy);} return (T) this;
    }
    public StrategyNested<T> withNewStrategy(){
    return new StrategyNested<T>();
    }
    public StrategyNested<T> withNewStrategyLike( DeploymentStrategy item){
    return new StrategyNested<T>(item);
    }
    public StrategyNested<T> editStrategy(){
    return withNewStrategyLike(getStrategy());
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public T withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (T) this;
    }
    public TemplateNested<T> withNewTemplate(){
    return new TemplateNested<T>();
    }
    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNested<T>(item);
    }
    public TemplateNested<T> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public ObjectReference getTemplateRef(){
    return this.templateRef!=null?this.templateRef.build():null;
    }
    public T withTemplateRef( ObjectReference templateRef){
    if (templateRef!=null){ this.templateRef= new ObjectReferenceBuilder(templateRef); _visitables.add(this.templateRef);} return (T) this;
    }
    public TemplateRefNested<T> withNewTemplateRef(){
    return new TemplateRefNested<T>();
    }
    public TemplateRefNested<T> withNewTemplateRefLike( ObjectReference item){
    return new TemplateRefNested<T>(item);
    }
    public TemplateRefNested<T> editTemplateRef(){
    return withNewTemplateRefLike(getTemplateRef());
    }
    public T addToTriggers( DeploymentTriggerPolicy item){
    if (item != null) {DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);_visitables.add(builder);this.triggers.add(builder);} return (T)this;
    }
    public List<DeploymentTriggerPolicy> getTriggers(){
    return build(triggers);
    }
    public T withTriggers( List<DeploymentTriggerPolicy> triggers){
    this.triggers.clear();if (triggers != null) {for (DeploymentTriggerPolicy item : triggers){this.addToTriggers(item);}} return (T) this;
    }
    public TriggersNested<T> addNewTrigger(){
    return new TriggersNested<T>();
    }
    public TriggersNested<T> addNewTriggerLike( DeploymentTriggerPolicy item){
    return new TriggersNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class StrategyNested<N> extends DeploymentStrategyFluent<StrategyNested<N>> implements Nested<N>{

        private final DeploymentStrategyBuilder builder;
    
             StrategyNested ( DeploymentStrategy item){
        this.builder = new DeploymentStrategyBuilder(this, item);
        }
             StrategyNested (){
        this.builder = new DeploymentStrategyBuilder(this);
        }
    
            public N endStrategy(){
            return and();
        }
            public N and(){
            return (N) DeploymentConfigSpecFluent.this.withStrategy(builder.build());
        }
    
}
    public class TemplateNested<N> extends PodTemplateSpecFluent<TemplateNested<N>> implements Nested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNested (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
             TemplateNested ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
    
            public N and(){
            return (N) DeploymentConfigSpecFluent.this.withTemplate(builder.build());
        }
            public N endTemplate(){
            return and();
        }
    
}
    public class TemplateRefNested<N> extends ObjectReferenceFluent<TemplateRefNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             TemplateRefNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
             TemplateRefNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
    
            public N and(){
            return (N) DeploymentConfigSpecFluent.this.withTemplateRef(builder.build());
        }
            public N endTemplateRef(){
            return and();
        }
    
}
    public class TriggersNested<N> extends DeploymentTriggerPolicyFluent<TriggersNested<N>> implements Nested<N>{

        private final DeploymentTriggerPolicyBuilder builder;
    
             TriggersNested ( DeploymentTriggerPolicy item){
        this.builder = new DeploymentTriggerPolicyBuilder(this, item);
        }
             TriggersNested (){
        this.builder = new DeploymentTriggerPolicyBuilder(this);
        }
    
            public N endTrigger(){
            return and();
        }
            public N and(){
            return (N) DeploymentConfigSpecFluent.this.addToTriggers(builder.build());
        }
    
}


}
