/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.BuildList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildListFluent<T extends BuildListFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    BuildList.ApiVersion apiVersion;
    List<VisitableBuilder<Build, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(BuildList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToItems(Build item) {
        if (item != null) {
            BuildBuilder builder = new BuildBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (T)this;
    }

    public List<Build> getItems() {
        return this.build(this.items);
    }

    public T withItems(List<Build> items) {
        this.items.clear();
        if (items != null) {
            for (Build item : items) {
                this.addToItems(item);
            }
        }
        return (T)this;
    }

    public ItemsNested<T> addNewItem() {
        return new ItemsNested();
    }

    public ItemsNested<T> addNewItemLike(Build item) {
        return new ItemsNested(item);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNested() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildListFluent.this.withMetadata(this.builder.build());
        }
    }

    public class ItemsNested<N>
    extends BuildFluent<ItemsNested<N>>
    implements Nested<N> {
        private final BuildBuilder builder;

        ItemsNested() {
            this.builder = new BuildBuilder(this);
        }

        ItemsNested(Build item) {
            this.builder = new BuildBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildListFluent.this.addToItems(this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

