package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class PodSpecFluent<T extends PodSpecFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Long activeDeadlineSeconds;     List<VisitableBuilder<Container, ?>> containers = new ArrayList();     String dnsPolicy;     String host;     Boolean hostNetwork;     List<LocalObjectReference> imagePullSecrets = new ArrayList();     Map<String, String> nodeSelector = new HashMap();     String restartPolicy;     String serviceAccount;     Long terminationGracePeriodSeconds;     List<VisitableBuilder<Volume, ?>> volumes = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public Long getActiveDeadlineSeconds(){
    return this.activeDeadlineSeconds;
    }
    public T withActiveDeadlineSeconds( Long activeDeadlineSeconds){
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (T) this;
    }
    public T addToContainers( Container item){
    if (item != null) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.add(builder);this.containers.add(builder);} return (T)this;
    }
    public List<Container> getContainers(){
    return build(containers);
    }
    public T withContainers( List<Container> containers){
    this.containers.clear();if (containers != null) {for (Container item : containers){this.addToContainers(item);}} return (T) this;
    }
    public ContainersNested<T> addNewContainer(){
    return new ContainersNested<T>();
    }
    public ContainersNested<T> addNewContainerLike( Container item){
    return new ContainersNested<T>(item);
    }
    public String getDnsPolicy(){
    return this.dnsPolicy;
    }
    public T withDnsPolicy( String dnsPolicy){
    this.dnsPolicy=dnsPolicy; return (T) this;
    }
    public String getHost(){
    return this.host;
    }
    public T withHost( String host){
    this.host=host; return (T) this;
    }
    public Boolean isHostNetwork(){
    return this.hostNetwork;
    }
    public T withHostNetwork( Boolean hostNetwork){
    this.hostNetwork=hostNetwork; return (T) this;
    }
    public T addToImagePullSecrets( LocalObjectReference item){
    if (item != null) {this.imagePullSecrets.add(item);} return (T)this;
    }
    public List<LocalObjectReference> getImagePullSecrets(){
    return this.imagePullSecrets;
    }
    public T withImagePullSecrets( List<LocalObjectReference> imagePullSecrets){
    this.imagePullSecrets.clear();if (imagePullSecrets != null) {for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} return (T) this;
    }
    public T addToNodeSelector( String key,  String value){
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (T)this;
    }
    public Map<String, String> getNodeSelector(){
    return this.nodeSelector;
    }
    public T withNodeSelector( Map<String, String> nodeSelector){
    this.nodeSelector.clear();if (nodeSelector != null) {this.nodeSelector.putAll(nodeSelector);} return (T) this;
    }
    public String getRestartPolicy(){
    return this.restartPolicy;
    }
    public T withRestartPolicy( String restartPolicy){
    this.restartPolicy=restartPolicy; return (T) this;
    }
    public String getServiceAccount(){
    return this.serviceAccount;
    }
    public T withServiceAccount( String serviceAccount){
    this.serviceAccount=serviceAccount; return (T) this;
    }
    public Long getTerminationGracePeriodSeconds(){
    return this.terminationGracePeriodSeconds;
    }
    public T withTerminationGracePeriodSeconds( Long terminationGracePeriodSeconds){
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (T) this;
    }
    public T addToVolumes( Volume item){
    if (item != null) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(builder);this.volumes.add(builder);} return (T)this;
    }
    public List<Volume> getVolumes(){
    return build(volumes);
    }
    public T withVolumes( List<Volume> volumes){
    this.volumes.clear();if (volumes != null) {for (Volume item : volumes){this.addToVolumes(item);}} return (T) this;
    }
    public VolumesNested<T> addNewVolume(){
    return new VolumesNested<T>();
    }
    public VolumesNested<T> addNewVolumeLike( Volume item){
    return new VolumesNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class ContainersNested<N> extends ContainerFluent<ContainersNested<N>> implements Nested<N>{

        private final ContainerBuilder builder;
    
             ContainersNested (){
        this.builder = new ContainerBuilder(this);
        }
             ContainersNested ( Container item){
        this.builder = new ContainerBuilder(this, item);
        }
    
            public N and(){
            return (N) PodSpecFluent.this.addToContainers(builder.build());
        }
            public N endContainer(){
            return and();
        }
    
}
    public class VolumesNested<N> extends VolumeFluent<VolumesNested<N>> implements Nested<N>{

        private final VolumeBuilder builder;
    
             VolumesNested (){
        this.builder = new VolumeBuilder(this);
        }
             VolumesNested ( Volume item){
        this.builder = new VolumeBuilder(this, item);
        }
    
            public N and(){
            return (N) PodSpecFluent.this.addToVolumes(builder.build());
        }
            public N endVolume(){
            return and();
        }
    
}


}
