package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class RouteSpecFluent<T extends RouteSpecFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String host;     String path;     VisitableBuilder<TLSConfig, ?> tls;     VisitableBuilder<ObjectReference, ?> to;     Map<String, Object> additionalProperties = new HashMap();

    public String getHost(){
    return this.host;
    }
    public T withHost( String host){
    this.host=host; return (T) this;
    }
    public String getPath(){
    return this.path;
    }
    public T withPath( String path){
    this.path=path; return (T) this;
    }
    public TLSConfig getTls(){
    return this.tls!=null?this.tls.build():null;
    }
    public T withTls( TLSConfig tls){
    if (tls!=null){ this.tls= new TLSConfigBuilder(tls); _visitables.add(this.tls);} return (T) this;
    }
    public TlsNested<T> withNewTls(){
    return new TlsNested<T>();
    }
    public TlsNested<T> withNewTlsLike( TLSConfig item){
    return new TlsNested<T>(item);
    }
    public TlsNested<T> editTls(){
    return withNewTlsLike(getTls());
    }
    public T withNewTls( String caCertificate,  String certificate,  String destinationCACertificate,  String key,  String termination){
    return withTls(new TLSConfig(caCertificate, certificate, destinationCACertificate, key, termination));
    }
    public ObjectReference getTo(){
    return this.to!=null?this.to.build():null;
    }
    public T withTo( ObjectReference to){
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.add(this.to);} return (T) this;
    }
    public ToNested<T> withNewTo(){
    return new ToNested<T>();
    }
    public ToNested<T> withNewToLike( ObjectReference item){
    return new ToNested<T>(item);
    }
    public ToNested<T> editTo(){
    return withNewToLike(getTo());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class TlsNested<N> extends TLSConfigFluent<TlsNested<N>> implements Nested<N>{

        private final TLSConfigBuilder builder;
    
             TlsNested ( TLSConfig item){
        this.builder = new TLSConfigBuilder(this, item);
        }
             TlsNested (){
        this.builder = new TLSConfigBuilder(this);
        }
    
            public N endTls(){
            return and();
        }
            public N and(){
            return (N) RouteSpecFluent.this.withTls(builder.build());
        }
    
}
    public class ToNested<N> extends ObjectReferenceFluent<ToNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             ToNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ToNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) RouteSpecFluent.this.withTo(builder.build());
        }
            public N endTo(){
            return and();
        }
    
}


}
